/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class RegionFunction
extends GeometryFunction {
    protected ADQLOperand parameter;

    public RegionFunction(ADQLOperand aDQLOperand) throws NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("The ADQL function REGION must have exactly one parameter !");
        }
        if (!aDQLOperand.isString()) {
            throw new Exception("The only required parameter of a REGION function must be a string literal !");
        }
        this.parameter = aDQLOperand;
    }

    public RegionFunction(RegionFunction regionFunction) throws Exception {
        this.parameter = (ADQLOperand)regionFunction.parameter.getCopy();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new RegionFunction(this);
    }

    @Override
    public String getName() {
        return "REGION";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.parameter;
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n == 0) {
            if (aDQLOperand == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of a " + this.getName() + " function !");
            }
            if (aDQLOperand instanceof ADQLOperand) {
                ADQLOperand aDQLOperand2 = this.parameter;
                this.parameter = aDQLOperand;
                return aDQLOperand2;
            }
            throw new Exception("Impossible to replace an ADQLOperand by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }
}

