/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class PointFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;

    public PointFunction(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3) throws UnsupportedOperationException, NullPointerException, Exception {
        super(aDQLOperand);
        if (aDQLOperand2 == null || aDQLOperand3 == null) {
            throw new NullPointerException("The POINT function must have non-null coordinates!");
        }
        this.coord1 = aDQLOperand2;
        this.coord2 = aDQLOperand3;
    }

    public PointFunction(PointFunction pointFunction) throws Exception {
        super(pointFunction);
        this.coord1 = (ADQLOperand)pointFunction.coord1.getCopy();
        this.coord2 = (ADQLOperand)pointFunction.coord2.getCopy();
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public void setCoord1(ADQLOperand aDQLOperand) throws NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("The first coordinate of a POINT function must be different from NULL !");
        }
        if (!aDQLOperand.isNumeric()) {
            throw new Exception("Coordinates of a POINT function must be numeric !");
        }
        this.coord1 = aDQLOperand;
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public void setCoord2(ADQLOperand aDQLOperand) throws NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("The second coordinate of a POINT function must be different from NULL !");
        }
        if (!aDQLOperand.isNumeric()) {
            throw new Exception("Coordinates of a POINT function must be numeric !");
        }
        this.coord2 = aDQLOperand;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new PointFunction(this);
    }

    @Override
    public String getName() {
        return "POINT";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2};
    }

    @Override
    public int getNbParameters() {
        return 3;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.getCoordinateSystem();
            }
            case 1: {
                return this.getCoord1();
            }
            case 2: {
                return this.getCoord2();
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + " !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove a parameter from the function " + this.getName() + " !");
        }
        ADQLOperand aDQLOperand2 = null;
        switch (n) {
            case 0: {
                aDQLOperand2 = this.getCoordinateSystem();
                this.setCoordinateSystem(aDQLOperand);
                break;
            }
            case 1: {
                aDQLOperand2 = this.getCoord1();
                this.setCoord1(aDQLOperand);
                break;
            }
            case 2: {
                aDQLOperand2 = this.getCoord2();
                this.setCoord2(aDQLOperand);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        return aDQLOperand2;
    }
}

