/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class BoxFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand width;
    private ADQLOperand height;

    public BoxFunction(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3, ADQLOperand aDQLOperand4, ADQLOperand aDQLOperand5) throws NullPointerException, Exception {
        super(aDQLOperand);
        if (aDQLOperand2 == null || aDQLOperand3 == null || aDQLOperand4 == null || aDQLOperand5 == null) {
            throw new NullPointerException("All the parameters of the BOX function must be different from NULL !");
        }
        this.coord1 = aDQLOperand2;
        this.coord2 = aDQLOperand3;
        this.width = aDQLOperand4;
        this.height = aDQLOperand5;
    }

    public BoxFunction(BoxFunction boxFunction) throws Exception {
        super(boxFunction);
        this.coord1 = (ADQLOperand)boxFunction.coord1.getCopy();
        this.coord2 = (ADQLOperand)boxFunction.coord2.getCopy();
        this.width = (ADQLOperand)boxFunction.width.getCopy();
        this.height = (ADQLOperand)boxFunction.height.getCopy();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new BoxFunction(this);
    }

    @Override
    public String getName() {
        return "BOX";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand aDQLOperand) {
        this.coord1 = aDQLOperand;
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand aDQLOperand) {
        this.coord2 = aDQLOperand;
    }

    public final ADQLOperand getWidth() {
        return this.width;
    }

    public final void setWidth(ADQLOperand aDQLOperand) {
        this.width = aDQLOperand;
    }

    public final ADQLOperand getHeight() {
        return this.height;
    }

    public final void setHeight(ADQLOperand aDQLOperand) {
        this.height = aDQLOperand;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.width, this.height};
    }

    @Override
    public int getNbParameters() {
        return 5;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.coord1;
            }
            case 2: {
                return this.coord2;
            }
            case 3: {
                return this.width;
            }
            case 4: {
                return this.height;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove one parameter from a " + this.getName() + " function !");
        }
        if (!(aDQLOperand instanceof ADQLOperand)) {
            throw new Exception("Impossible to replace an ADQLOperand by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
        }
        ADQLOperand aDQLOperand2 = null;
        switch (n) {
            case 0: {
                aDQLOperand2 = this.coordSys;
                this.setCoordinateSystem(aDQLOperand);
                break;
            }
            case 1: {
                aDQLOperand2 = this.coord1;
                this.coord1 = aDQLOperand;
                break;
            }
            case 2: {
                aDQLOperand2 = this.coord2;
                this.coord2 = aDQLOperand;
                break;
            }
            case 3: {
                aDQLOperand2 = this.width;
                this.width = aDQLOperand;
                break;
            }
            case 4: {
                aDQLOperand2 = this.height;
                this.height = aDQLOperand;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        return aDQLOperand2;
    }
}

