/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class AreaFunction
extends GeometryFunction {
    private GeometryFunction.GeometryValue<GeometryFunction> parameter;

    public AreaFunction(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) throws NullPointerException {
        if (geometryValue == null) {
            throw new NullPointerException("The only parameter of an AREA function must be different from NULL !");
        }
        if (!(geometryValue instanceof GeometryFunction.GeometryValue)) {
            throw new NullPointerException("The ADQL function AREA must have one geometric parameter (a GeometryValue) !");
        }
        this.parameter = geometryValue;
    }

    public AreaFunction(AreaFunction areaFunction) throws Exception {
        this.parameter = (GeometryFunction.GeometryValue)areaFunction.parameter.getCopy();
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getParameter() {
        return this.parameter;
    }

    public final void setParameter(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) {
        this.parameter = geometryValue;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new AreaFunction(this);
    }

    @Override
    public String getName() {
        return "AREA";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.parameter.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n == 0) {
            ADQLOperand aDQLOperand2 = this.parameter.getValue();
            if (aDQLOperand == null) {
                throw new NullPointerException("");
            }
            if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                this.parameter = (GeometryFunction.GeometryValue)aDQLOperand;
            } else if (aDQLOperand instanceof ADQLColumn) {
                this.parameter.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof GeometryFunction) {
                this.parameter.setGeometry((GeometryFunction)aDQLOperand);
            } else {
                throw new Exception("Impossible to replace a GeometryValue/Column/GeometryFunction by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
            }
            return aDQLOperand2;
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }
}

