/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.SQLFunctionType;

public class SQLFunction
extends ADQLFunction {
    private final SQLFunctionType type;
    private ADQLOperand param = null;
    private boolean distinct = false;

    public SQLFunction(SQLFunctionType sQLFunctionType, ADQLOperand aDQLOperand) throws NullPointerException {
        this(sQLFunctionType, aDQLOperand, false);
    }

    public SQLFunction(SQLFunctionType sQLFunctionType, ADQLOperand aDQLOperand, boolean bl) throws NullPointerException {
        if (sQLFunctionType == null) {
            throw new NullPointerException("Impossible to build a SQLFunction without its type (COUNT, SUM, AVG, ...) !");
        }
        this.type = sQLFunctionType;
        if (this.type == SQLFunctionType.COUNT_ALL) {
            this.param = null;
        } else {
            if (aDQLOperand == null) {
                throw new NullPointerException("Impossible to build the SQL function \"" + this.type.name() + "\" without the operand on which it must apply !");
            }
            this.param = aDQLOperand;
        }
        this.distinct = bl;
    }

    public SQLFunction(SQLFunction sQLFunction) throws Exception {
        this.type = sQLFunction.type;
        this.param = (ADQLOperand)sQLFunction.param.getCopy();
        this.distinct = sQLFunction.distinct;
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public final SQLFunctionType getType() {
        return this.type;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new SQLFunction(this);
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        if (this.param != null) {
            return new ADQLOperand[]{this.param};
        }
        return new ADQLOperand[0];
    }

    @Override
    public int getNbParameters() {
        return this.type == SQLFunctionType.COUNT_ALL ? 0 : 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.type.name() + "\" !");
        }
        return this.param;
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n < 0 || n >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.type.name() + "\" !");
        }
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove the only required parameter of the function \"" + this.type.name() + "\" !");
        }
        ADQLOperand aDQLOperand2 = this.param;
        this.param = aDQLOperand;
        return aDQLOperand2;
    }

    @Override
    public String toADQL() {
        if (this.type == SQLFunctionType.COUNT_ALL) {
            return "COUNT(" + (this.distinct ? "DISTINCT " : "") + "*)";
        }
        return this.getName() + "(" + (this.distinct ? "DISTINCT " : "") + this.param.toADQL() + ")";
    }
}

