/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

public enum OperationType {
    SUM,
    SUB,
    MULT,
    DIV;


    public static String[] getOperators() {
        return new String[]{SUM.toString(), SUB.toString(), MULT.toString(), DIV.toString()};
    }

    public static OperationType getOperator(String string) throws UnsupportedOperationException {
        if (string.equalsIgnoreCase("+")) {
            return SUM;
        }
        if (string.equalsIgnoreCase("-")) {
            return SUB;
        }
        if (string.equalsIgnoreCase("*")) {
            return MULT;
        }
        if (string.equalsIgnoreCase("/")) {
            return DIV;
        }
        throw new UnsupportedOperationException("Numeric operation unknown: \"" + string + "\" !");
    }

    public String toADQL() {
        return this.toString();
    }

    public String toString() {
        switch (this) {
            case SUM: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MULT: {
                return "*";
            }
            case DIV: {
                return "/";
            }
        }
        return "???";
    }
}

