/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public final class NegativeOperand
implements ADQLOperand {
    private ADQLOperand operand;

    public NegativeOperand(ADQLOperand aDQLOperand) throws NullPointerException, UnsupportedOperationException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to negativate an operand equals to NULL !");
        }
        if (!aDQLOperand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to negativate a non-numeric operand (" + aDQLOperand.toADQL() + ") !");
        }
        this.operand = aDQLOperand;
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        NegativeOperand negativeOperand = new NegativeOperand((ADQLOperand)this.operand.getCopy());
        return negativeOperand;
    }

    @Override
    public String getName() {
        return "-" + this.operand.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = NegativeOperand.this.operand == null;
            }

            @Override
            public ADQLObject next() {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return NegativeOperand.this.operand;
            }

            @Override
            public boolean hasNext() {
                return !this.operandGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (!this.operandGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLOperand && ((ADQLOperand)aDQLObject).isNumeric()) {
                    NegativeOperand.this.operand = (ADQLOperand)aDQLObject;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the operand \"" + NegativeOperand.this.operand.toADQL() + "\" by \"" + aDQLObject.toADQL() + "\" in the NegativeOperand \"" + NegativeOperand.this.toADQL() + "\" because the replacer is not an ADQLOperand or is not numeric !");
                }
            }

            @Override
            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + NegativeOperand.this.operand.toADQL() + ") of a NegativeOperand (" + NegativeOperand.this.toADQL() + "). However you can remove the whole NegativeOperand.");
            }
        };
    }

    @Override
    public String toADQL() {
        return "-" + this.operand.toADQL();
    }
}

