/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.query.ADQLObject;
import adql.query.ClauseConstraints;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import java.util.ArrayList;
import java.util.Collection;

public class OuterJoin
extends ADQLJoin {
    private OuterType type = OuterType.LEFT;

    public OuterJoin(FromContent fromContent, FromContent fromContent2, OuterType outerType) {
        super(fromContent, fromContent2);
        this.setNatural(true);
        this.setType(outerType);
    }

    public OuterJoin(FromContent fromContent, FromContent fromContent2, OuterType outerType, ClauseConstraints clauseConstraints) {
        super(fromContent, fromContent2);
        this.setJoinCondition(clauseConstraints);
        this.setType(outerType);
    }

    public OuterJoin(FromContent fromContent, FromContent fromContent2, OuterType outerType, Collection<ADQLColumn> collection) {
        super(fromContent, fromContent2);
        this.setJoinedColumns(new ArrayList<ADQLColumn>(collection));
        this.setType(outerType);
    }

    public OuterJoin(OuterJoin outerJoin) throws Exception {
        super(outerJoin);
        this.setType(outerJoin.type);
    }

    @Override
    public String getJoinType() {
        return this.type.toString() + " OUTER JOIN";
    }

    public final OuterType getType() {
        return this.type;
    }

    public void setType(OuterType outerType) {
        if (outerType != null) {
            this.type = outerType;
        }
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new OuterJoin(this);
    }

    public static enum OuterType {
        LEFT,
        RIGHT,
        FULL;

    }
}

