/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class Comparison
implements ADQLConstraint {
    private ADQLOperand leftOperand;
    private ComparisonOperator compOperator;
    private ADQLOperand rightOperand;

    public Comparison(ADQLOperand aDQLOperand, ComparisonOperator comparisonOperator, ADQLOperand aDQLOperand2) throws NullPointerException, UnsupportedOperationException {
        this.setLeftOperand(aDQLOperand);
        this.setRightOperand(aDQLOperand2);
        this.setOperation(comparisonOperator);
    }

    public Comparison(Comparison comparison) throws Exception {
        this.leftOperand = (ADQLOperand)comparison.leftOperand.getCopy();
        this.compOperator = comparison.compOperator;
        this.rightOperand = (ADQLOperand)comparison.rightOperand.getCopy();
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand aDQLOperand) throws NullPointerException, UnsupportedOperationException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with a NULL operand !");
        }
        if (this.rightOperand != null && aDQLOperand.isNumeric() != this.rightOperand.isNumeric() && aDQLOperand.isString() != this.rightOperand.isString()) {
            throw new UnsupportedOperationException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with \"" + aDQLOperand.toADQL() + "\" because its type is not compatible with the type of the right operand !");
        }
        if (this.compOperator != null && aDQLOperand.isNumeric() && (this.compOperator == ComparisonOperator.LIKE || this.compOperator == ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with \"" + aDQLOperand.toADQL() + "\" because the comparison operator " + this.compOperator.toADQL() + " is not applicable on numeric operands !");
        }
        this.leftOperand = aDQLOperand;
    }

    public ComparisonOperator getOperator() {
        return this.compOperator;
    }

    public void setOperation(ComparisonOperator comparisonOperator) throws NullPointerException, UnsupportedOperationException {
        if (comparisonOperator == null) {
            throw new NullPointerException("Impossible to update the comparison operator (" + this.compOperator.toADQL() + ") with a NULL operand !");
        }
        if (!(this.leftOperand.isString() && this.rightOperand.isString() || comparisonOperator != ComparisonOperator.LIKE && comparisonOperator != ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the comparison operator" + (this.compOperator != null ? " (" + this.compOperator.toADQL() + ")" : "") + " by " + comparisonOperator.toADQL() + " because the two operands (\"" + this.leftOperand.toADQL() + "\" & \"" + this.rightOperand.toADQL() + "\") are not all Strings !");
        }
        this.compOperator = comparisonOperator;
    }

    public ADQLOperand getRightOperand() {
        return this.rightOperand;
    }

    public void setRightOperand(ADQLOperand aDQLOperand) throws NullPointerException, UnsupportedOperationException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with a NULL operand !");
        }
        if (this.leftOperand != null && aDQLOperand.isNumeric() != this.leftOperand.isNumeric() && aDQLOperand.isString() != this.leftOperand.isString()) {
            throw new UnsupportedOperationException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with \"" + aDQLOperand.toADQL() + "\" because its type is not compatible with the type of the left operand !");
        }
        if (this.compOperator != null && aDQLOperand.isNumeric() && (this.compOperator == ComparisonOperator.LIKE || this.compOperator == ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with \"" + aDQLOperand.toADQL() + "\" because the comparison operator " + this.compOperator.toADQL() + " is not applicable on numeric operands !");
        }
        this.rightOperand = aDQLOperand;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Comparison(this);
    }

    @Override
    public String getName() {
        return this.compOperator.toADQL();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return Comparison.this.leftOperand;
                }
                if (this.index == 1) {
                    return Comparison.this.rightOperand;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLOperand) {
                    if (this.index == 0) {
                        Comparison.this.leftOperand = (ADQLOperand)aDQLObject;
                    } else if (this.index == 1) {
                        Comparison.this.rightOperand = (ADQLOperand)aDQLObject;
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + aDQLObject.getClass().getName() + " in a comparison !");
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove an operand from a comparison !");
            }
        };
    }

    @Override
    public String toADQL() {
        return (this.leftOperand == null ? "NULL" : this.leftOperand.toADQL()) + " " + (this.compOperator == null ? "NULL" : this.compOperator.toADQL()) + " " + (this.rightOperand == null ? "NULL" : this.rightOperand.toADQL());
    }
}

