/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.from.ADQLTable;
import java.util.NoSuchElementException;

public final class SelectAllColumns
extends SelectItem {
    private ADQLQuery query = null;
    private ADQLTable adqlTable = null;

    public SelectAllColumns(ADQLQuery aDQLQuery) {
        super(null, null);
        this.query = aDQLQuery;
    }

    public SelectAllColumns(ADQLTable aDQLTable) {
        super(null, null);
        this.adqlTable = aDQLTable;
    }

    public SelectAllColumns(SelectAllColumns selectAllColumns) throws Exception {
        super(selectAllColumns);
    }

    public final ADQLQuery getQuery() {
        return this.query;
    }

    public final void setQuery(ADQLQuery aDQLQuery) {
        if (aDQLQuery != null) {
            this.query = aDQLQuery;
            this.adqlTable = null;
        }
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable aDQLTable) {
        if (aDQLTable != null) {
            this.adqlTable = aDQLTable;
            this.query = null;
        }
    }

    @Override
    public final ADQLObject getCopy() throws Exception {
        return new SelectAllColumns(this);
    }

    @Override
    public final String getName() {
        return "*";
    }

    @Override
    public final ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean tableGot;
            {
                this.tableGot = SelectAllColumns.this.adqlTable == null;
            }

            @Override
            public ADQLObject next() throws NoSuchElementException {
                if (this.tableGot) {
                    throw new NoSuchElementException();
                }
                this.tableGot = true;
                return SelectAllColumns.this.adqlTable;
            }

            @Override
            public boolean hasNext() {
                return !this.tableGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (aDQLObject == null) {
                    this.remove();
                } else {
                    if (!this.tableGot) {
                        throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                    }
                    if (!(aDQLObject instanceof ADQLTable)) {
                        throw new IllegalStateException("Impossible to replace an ADQLTable by a " + aDQLObject.getClass().getName() + " !");
                    }
                    SelectAllColumns.this.adqlTable = (ADQLTable)aDQLObject;
                }
            }

            @Override
            public void remove() {
                if (!this.tableGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + SelectAllColumns.this.adqlTable.toADQL() + ") from a SelectItem (" + SelectAllColumns.this.toADQL() + ") !");
            }
        };
    }

    @Override
    public final String toADQL() {
        if (this.adqlTable != null) {
            if (this.adqlTable.hasAlias()) {
                return (this.adqlTable.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + this.adqlTable.getAlias() + "\"" : this.adqlTable.getAlias()) + ".*";
            }
            return this.adqlTable.getFullTableName() + ".*";
        }
        return "*";
    }
}

