/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.SelectItem;
import adql.query.operand.ADQLOperand;
import java.util.ArrayList;

public class ClauseSelect
extends ClauseADQL<SelectItem> {
    private boolean distinct = false;
    private int limit = -1;

    public ClauseSelect() {
        this(false, -1);
    }

    public ClauseSelect(boolean bl) {
        this(bl, -1);
    }

    public ClauseSelect(int n) {
        this(false, n);
    }

    public ClauseSelect(boolean bl, int n) {
        super("SELECT");
        this.distinct = bl;
        this.limit = n;
    }

    public ClauseSelect(ClauseSelect clauseSelect) throws Exception {
        super(clauseSelect);
        this.distinct = clauseSelect.distinct;
        this.limit = clauseSelect.limit;
    }

    public final boolean distinctColumns() {
        return this.distinct;
    }

    public final void setDistinctColumns(boolean bl) {
        this.distinct = bl;
    }

    public final boolean hasLimit() {
        return this.limit >= 0;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setNoLimit() {
        this.limit = -1;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public boolean add(ADQLOperand aDQLOperand) throws NullPointerException {
        if (aDQLOperand == null) {
            throw new NullPointerException("It is impossible to add NULL items to a SELECT clause !");
        }
        return this.add(new SelectItem(aDQLOperand));
    }

    @Override
    public void add(int n, ADQLOperand aDQLOperand) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (aDQLOperand == null) {
            throw new NullPointerException("It is impossible to add NULL items to a SELECT clause !");
        }
        this.add(n, new SelectItem(aDQLOperand));
    }

    @Override
    public ADQLOperand set(int n, ADQLOperand aDQLOperand) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (aDQLOperand == null) {
            throw new NullPointerException("It is impossible to replace a SELECT item by a NULL item into a SELECT clause !");
        }
        SelectItem selectItem = this.set(n, new SelectItem(aDQLOperand));
        return selectItem.getOperand();
    }

    public ADQLOperand searchByIndex(int n) throws ArrayIndexOutOfBoundsException {
        return ((SelectItem)this.get(n)).getOperand();
    }

    public ADQLOperand searchByAlias(String string) {
        ArrayList<SelectItem> arrayList = this.searchByAlias(string, true);
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.get(0).getOperand();
    }

    public ArrayList<SelectItem> searchByAlias(String string, boolean bl) {
        if (string == null) {
            return new ArrayList<SelectItem>(0);
        }
        ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>();
        for (SelectItem selectItem : this) {
            if (!selectItem.hasAlias()) continue;
            if (!bl) {
                if (selectItem.isCaseSensitive()) {
                    if (!selectItem.getAlias().equals(string.toLowerCase())) continue;
                    arrayList.add(selectItem);
                    continue;
                }
                if (!selectItem.getAlias().equalsIgnoreCase(string)) continue;
                arrayList.add(selectItem);
                continue;
            }
            if (selectItem.isCaseSensitive()) {
                if (!selectItem.getAlias().equals(string)) continue;
                arrayList.add(selectItem);
                continue;
            }
            if (!selectItem.getAlias().toLowerCase().equals(string)) continue;
            arrayList.add(selectItem);
        }
        return arrayList;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ClauseSelect(this);
    }

    @Override
    public String toADQL() {
        String string = null;
        for (int i = 0; i < this.size(); ++i) {
            string = i == 0 ? this.getName() + (this.distinct ? " DISTINCT" : "") + (this.hasLimit() ? " TOP " + this.limit : "") : string + " " + this.getSeparator(i);
            string = string + " " + ((SelectItem)this.get(i)).toADQL();
        }
        return string;
    }
}

