/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.Token;
import adql.query.TextPosition;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected TextPosition position = null;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(ParseException.initialise(token, nArray, stringArray));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
        this.position = new TextPosition(this.currentToken.next);
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    public ParseException(String string, TextPosition textPosition) {
        this(string);
        this.position = textPosition;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    private static String initialise(Token token, int[][] nArray, String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i].length) {
                n = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuffer.append(stringArray[nArray[i][j]]);
            }
            stringBuffer.append(" ");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(" Encountered \"");
        Token token2 = token.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer2.append(' ');
            }
            if (token2.kind == 0) {
                stringBuffer2.append(stringArray[0]);
                break;
            }
            stringBuffer2.append(ParseException.add_escapes(token2.image));
            token2 = token2.next;
        }
        stringBuffer2.append("\".");
        if (nArray.length == 1) {
            stringBuffer2.append(" Was expecting: ");
        } else {
            stringBuffer2.append(" Was expecting one of: ");
        }
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }

    static String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

