/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.Token;
import adql.query.IdentifierField;
import adql.query.TextPosition;

public class IdentifierItems {
    private IdentifierItem[] identifiers = new IdentifierItem[4];
    private int count = 0;
    private boolean tableIdent = false;

    public IdentifierItems(boolean bl) {
        this.tableIdent = bl;
    }

    public void append(IdentifierItem identifierItem) {
        if (this.count >= 4) {
            return;
        }
        this.identifiers[this.count++] = identifierItem;
    }

    public int size() {
        return this.count;
    }

    public IdentifierItem get(int n) {
        return n < 0 || this.identifiers[n] == null ? null : this.identifiers[n];
    }

    public String getIdentifier(int n) {
        return n < 0 || this.identifiers[n] == null ? null : this.identifiers[n].identifier;
    }

    public String getCatalog() {
        return this.getIdentifier(this.tableIdent ? this.count - 3 : this.count - 4);
    }

    public String getSchema() {
        return this.getIdentifier(this.tableIdent ? this.count - 2 : this.count - 3);
    }

    public String getTable() {
        return this.getIdentifier(this.tableIdent ? this.count - 1 : this.count - 2);
    }

    public String getColumn() {
        return this.getIdentifier(this.tableIdent ? -1 : this.count - 1);
    }

    public int getBeginLine() {
        return this.count == 0 || this.identifiers[0] == null ? -1 : this.identifiers[0].position.beginLine;
    }

    public int getEndLine() {
        return this.count == 0 || this.identifiers[this.count - 1] == null ? -1 : this.identifiers[this.count - 1].position.endLine;
    }

    public int getBeginColumn() {
        return this.count == 0 || this.identifiers[0] == null ? -1 : this.identifiers[0].position.beginColumn;
    }

    public int getEndColumn() {
        return this.count == 0 || this.identifiers[this.count - 1] == null ? -1 : this.identifiers[this.count - 1].position.endColumn;
    }

    public TextPosition getPosition() {
        return new TextPosition(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    public byte getCaseSensitivity() {
        byte by = IdentifierField.getFullCaseSensitive(false);
        if (this.count == 0) {
            return by;
        }
        int n = this.count - 1;
        if (!this.tableIdent) {
            if (this.identifiers[n] != null) {
                by = IdentifierField.COLUMN.setCaseSensitive(by, this.identifiers[n].caseSensitivity);
            }
            --n;
        }
        if (n < 0) {
            return by;
        }
        if (this.identifiers[n] != null) {
            by = IdentifierField.TABLE.setCaseSensitive(by, this.identifiers[n].caseSensitivity);
        }
        if (--n < 0) {
            return by;
        }
        if (this.identifiers[n] != null) {
            by = IdentifierField.SCHEMA.setCaseSensitive(by, this.identifiers[n].caseSensitivity);
        }
        if (--n < 0) {
            return by;
        }
        if (this.identifiers[n] != null) {
            by = IdentifierField.CATALOG.setCaseSensitive(by, this.identifiers[n].caseSensitivity);
        }
        return by;
    }

    public boolean getColumnCaseSensitivity() {
        if (this.count == 0 || this.tableIdent || this.identifiers[this.count - 1] == null) {
            return false;
        }
        return this.identifiers[this.count - 1].caseSensitivity;
    }

    public String join(String string) {
        if (this.count == 0) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (this.identifiers[i] == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.identifiers[i] == null ? "" : this.identifiers[i].identifier);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.join(".");
    }

    public static class IdentifierItem {
        public String identifier = null;
        public boolean caseSensitivity = false;
        public TextPosition position = null;

        public IdentifierItem(Token token, boolean bl) {
            this.identifier = token.image;
            this.caseSensitivity = bl;
            this.position = new TextPosition(token);
        }

        public String toString() {
            return this.identifier;
        }
    }
}

