/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.ParseException;
import adql.query.from.ADQLTable;
import adql.query.operand.ADQLColumn;

public class UnresolvedTableException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private final String tableName;

    public UnresolvedTableException(ADQLTable aDQLTable) {
        super(UnresolvedTableException.buildMessage("Unknown table", aDQLTable));
        this.initPosition(aDQLTable);
        this.tableName = aDQLTable != null ? aDQLTable.getTableName() : null;
    }

    public UnresolvedTableException(ADQLTable aDQLTable, String string, String string2) {
        super(UnresolvedTableException.buildMessage("Ambiguous table name", aDQLTable, string, string2));
        this.initPosition(aDQLTable);
        this.tableName = aDQLTable != null ? aDQLTable.getTableName() : null;
    }

    protected final void initPosition(ADQLTable aDQLTable) {
        this.position = aDQLTable.getPosition();
    }

    public UnresolvedTableException(ADQLColumn aDQLColumn) {
        super(UnresolvedTableException.buildMessage("Unknown table reference", aDQLColumn));
        this.initPosition(aDQLColumn);
        this.tableName = aDQLColumn != null ? aDQLColumn.getTableName() : null;
    }

    public UnresolvedTableException(ADQLColumn aDQLColumn, String string, String string2) {
        super(UnresolvedTableException.buildMessage("Ambiguous table reference", aDQLColumn, string, string2));
        this.initPosition(aDQLColumn);
        this.tableName = aDQLColumn != null ? aDQLColumn.getTableName() : null;
    }

    protected final void initPosition(ADQLColumn aDQLColumn) {
        this.position = aDQLColumn.getPosition();
    }

    private static final String buildMessage(String string, ADQLTable aDQLTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" \"");
        if (aDQLTable.isSubQuery()) {
            stringBuffer.append(aDQLTable.getAlias()).append("\" !");
        } else {
            stringBuffer.append(aDQLTable.getFullTableName()).append("\"").append(aDQLTable.hasAlias() ? " (alias " + aDQLTable.getAlias() + ")" : "").append(" !");
        }
        return stringBuffer.toString();
    }

    private static final String buildMessage(String string, ADQLTable aDQLTable, String string2, String string3) {
        if (string2 != null && string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(UnresolvedTableException.buildMessage(string, aDQLTable));
            stringBuffer.append(" It may be (at least) \"").append(string2).append("\" or \"").append(string3).append("\".");
            return stringBuffer.toString();
        }
        return UnresolvedTableException.buildMessage(string, aDQLTable);
    }

    private static final String buildMessage(String string, ADQLColumn aDQLColumn) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" \"").append(aDQLColumn.getFullColumnPrefix()).append("\" in \"").append(aDQLColumn.getFullColumnName()).append("\" !");
        return stringBuffer.toString();
    }

    private static final String buildMessage(String string, ADQLColumn aDQLColumn, String string2, String string3) {
        if (string2 != null && string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(UnresolvedTableException.buildMessage(string, aDQLColumn));
            stringBuffer.append(" It may come (at least) from \"").append(string2).append("\" or from \"").append(string3).append("\".");
            return stringBuffer.toString();
        }
        return UnresolvedTableException.buildMessage(string, aDQLColumn);
    }

    public final String getTableName() {
        return this.tableName;
    }
}

