/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.parser.ADQLQueryFactory;
import adql.parser.ParseException;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.StringConstant;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class STCS {
    private static final String coordSysRegExp = Frame.regexp + "?\\s*" + RefPos.regexp + "?\\s*" + Flavor.regexp + "?";
    private static final String onlyCoordSysRegExp = "^\\s*" + coordSysRegExp + "\\s*$";
    private static final String defaultCoordSysRegExp = "^\\s*" + (Object)((Object)Frame.DEFAULT) + "?\\s*" + (Object)((Object)RefPos.DEFAULT) + "?\\s*" + (Object)((Object)Flavor.DEFAULT) + "?\\s*$";
    private static final String allowedCoordSysRegExp = "^\\s*" + STCS.buildAllowedRegExp(Frame.regexp) + "\\s+" + STCS.buildAllowedRegExp(RefPos.regexp) + "\\s+" + STCS.buildAllowedRegExp(Flavor.regexp) + "\\s*$";
    private static final Pattern allowedCoordSysPattern = Pattern.compile(allowedCoordSysRegExp);
    private static final String COORD_SYS_SYNTAX = "\"[" + Frame.regexp + "] [" + RefPos.regexp + "] [" + Flavor.regexp + "]\" ; an empty string is also allowed and will be interpreted as the coordinate system locally used";

    private STCS() {
    }

    private static String buildAllowedRegExp(String string) {
        return "(" + string + "|\\*|(\\(\\s*" + string + "\\s*(\\|\\s*" + string + "\\s*)*\\)))";
    }

    private static String buildRegexp(Class<?> clazz) throws IllegalArgumentException {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("An enum class was expected, but a " + clazz.getName() + " has been given!");
        }
        ?[] objArray = clazz.getEnumConstants();
        if (objArray == null || objArray.length == 0) {
            return "\\s*";
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < objArray.length; ++i) {
            stringBuffer.append(objArray[i]);
            if (i + 1 >= objArray.length) continue;
            stringBuffer.append('|');
        }
        return stringBuffer.append(')').toString();
    }

    public static CoordSys parseCoordSys(String string) throws ParseException {
        return new STCSParser().parseCoordSys(string);
    }

    public static String toSTCS(CoordSys coordSys) {
        if (coordSys == null) {
            return "";
        }
        return coordSys.toSTCS();
    }

    public static String buildCoordSysRegExp(String[] stringArray) throws ParseException {
        if (stringArray == null) {
            return onlyCoordSysRegExp;
        }
        if (stringArray.length == 0) {
            return defaultCoordSysRegExp;
        }
        StringBuffer stringBuffer = new StringBuffer("^\\s*(");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (n > 0) {
                stringBuffer.append('|');
            }
            ++n;
            Matcher matcher = allowedCoordSysPattern.matcher(stringArray[i].toUpperCase());
            if (matcher.matches()) {
                stringBuffer.append('(');
                for (int j = 0; j < 3; ++j) {
                    if (matcher.group(2 + 6 * j) != null) {
                        stringBuffer.append('(').append(STCS.defaultChoice(j, matcher.group(2 + 6 * j))).append(matcher.group(2 + 6 * j)).append(')');
                    } else if (matcher.group(3 + 6 * j) != null) {
                        stringBuffer.append('(').append(STCS.defaultChoice(j, matcher.group(3 + 6 * j))).append(matcher.group(3 + 6 * j).replaceAll("\\s", "").substring(1));
                    } else {
                        switch (j) {
                            case 0: {
                                stringBuffer.append(Frame.regexp);
                                break;
                            }
                            case 1: {
                                stringBuffer.append(RefPos.regexp);
                                break;
                            }
                            case 2: {
                                stringBuffer.append(Flavor.regexp);
                            }
                        }
                        stringBuffer.append('?');
                    }
                    stringBuffer.append("\\s*");
                }
                stringBuffer.append(')');
                continue;
            }
            throw new ParseException("Wrong allowed coordinate system syntax for the " + (i + 1) + "-th item: \"" + stringArray[i] + "\"! Expected: \"frameRegExp refposRegExp flavorRegExp\" ; where each xxxRegExp = (xxx | '*' | '('xxx ('|' xxx)*')'), frame=\"" + Frame.regexp + "\", refpos=\"" + RefPos.regexp + "\" and flavor=\"" + Flavor.regexp + "\" ; an empty string is also allowed and will be interpreted as '*' (so all possible values).");
        }
        stringBuffer.append(")\\s*$");
        return n > 0 ? stringBuffer.toString() : defaultCoordSysRegExp;
    }

    private static String defaultChoice(int n, String string) {
        switch (n) {
            case 0: {
                return string.contains(Frame.DEFAULT.toString()) ? "" : (Object)((Object)Frame.DEFAULT) + "|";
            }
            case 1: {
                return string.contains(RefPos.DEFAULT.toString()) ? "" : (Object)((Object)RefPos.DEFAULT) + "|";
            }
            case 2: {
                return string.contains(Flavor.DEFAULT.toString()) ? "" : (Object)((Object)Flavor.DEFAULT) + "|";
            }
        }
        return "";
    }

    public static Region parseRegion(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            throw new ParseException("Missing STC-S expression to parse!");
        }
        return new STCSParser().parseRegion(string);
    }

    public static String toSTCS(Region region) {
        if (region == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        return region.toSTCS();
    }

    public static String toSTCS(GeometryFunction geometryFunction) throws ParseException {
        if (geometryFunction == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        return new Region(geometryFunction).toSTCS();
    }

    private static class STCSParser {
        private static final String numericRegExp = "(\\+|-)?(\\d+(\\.\\d*)?|\\.\\d+)([Ee](\\+|-)?\\d+)?";
        private int pos;
        private String stcs;
        private String token;
        private StringBuffer buffer;

        public CoordSys parseCoordSys(String string) throws ParseException {
            this.init(string);
            CoordSys coordSys = null;
            try {
                coordSys = this.coordSys();
                this.end(COORD_SYS_SYNTAX);
                return coordSys;
            }
            catch (EOEException eOEException) {
                eOEException.printStackTrace();
                return new CoordSys();
            }
        }

        public Region parseRegion(String string) throws ParseException {
            this.init(string);
            Region region = this.region();
            this.end("\"POSITION <coordsys> <coordPair>\", \"CIRCLE <coordSys> <coordPair> <numeric>\", \"BOX <coordSys> <coordPair> <coordPair>\", \"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", \"UNION <coordSys> ( <region> <region> [<region> ...] )\", \"INTERSECTION [<coordSys>] ( <region> <region> [<region> ...] )\" or \"NOT ( <region> )\"");
            return region;
        }

        private void init(String string) {
            this.stcs = string == null ? "" : string;
            this.token = null;
            this.buffer = new StringBuffer();
            this.pos = 0;
        }

        private void end(String string) throws ParseException {
            this.skipSpaces();
            if (this.stcs.length() > 0 && this.pos < this.stcs.length()) {
                throw new ParseException("Incorrect syntax: \"" + this.stcs.substring(this.pos) + "\" was unexpected! Expected syntax: " + string + ".", new TextPosition(1, this.pos, 1, this.stcs.length()));
            }
            this.buffer = null;
            this.stcs = null;
            this.token = null;
        }

        private void skipSpaces() {
            while (this.pos < this.stcs.length() && Character.isWhitespace(this.stcs.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private String nextToken() throws EOEException {
            this.skipSpaces();
            while (this.pos < this.stcs.length() && !Character.isWhitespace(this.stcs.charAt(this.pos)) && this.stcs.charAt(this.pos) != '(' && this.stcs.charAt(this.pos) != ')') {
                this.buffer.append(this.stcs.charAt(this.pos++));
            }
            if (this.buffer.length() == 0) {
                throw new EOEException();
            }
            this.token = this.buffer.toString();
            this.buffer.delete(0, this.token.length());
            return this.token;
        }

        private double numeric() throws ParseException {
            if (this.nextToken().matches(numericRegExp)) {
                return Double.parseDouble(this.token);
            }
            throw new ParseException("a numeric was expected!", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
        }

        private double[] coordPair() throws ParseException {
            this.skipSpaces();
            int n = this.pos;
            try {
                return new double[]{this.numeric(), this.numeric()};
            }
            catch (ParseException parseException) {
                if (parseException instanceof EOEException) {
                    throw parseException;
                }
                throw new ParseException("a coordinates pair (2 numerics separated by one or more spaces) was expected!", new TextPosition(1, n, 1, this.pos));
            }
        }

        private CoordSys coordSys() throws ParseException {
            this.skipSpaces();
            String string = this.token;
            int n = this.pos;
            Frame frame = null;
            RefPos refPos = null;
            Flavor flavor = null;
            try {
                this.nextToken();
                frame = this.frame();
                if (frame != null) {
                    n = this.pos;
                    string = this.token;
                    this.nextToken();
                }
                if ((refPos = this.refpos()) != null) {
                    n = this.pos;
                    string = this.token;
                    this.nextToken();
                }
                if ((flavor = this.flavor()) == null) {
                    this.pos = n;
                    this.token = string;
                }
            }
            catch (EOEException eOEException) {
                // empty catch block
            }
            try {
                return new CoordSys(frame, refPos, flavor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), new TextPosition(1, n, 1, this.pos));
            }
        }

        private Frame frame() {
            try {
                return Frame.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        private RefPos refpos() {
            try {
                return RefPos.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        private Flavor flavor() {
            try {
                return Flavor.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        private Region region() throws ParseException {
            this.skipSpaces();
            int n = this.pos;
            this.token = this.nextToken().toUpperCase();
            if (this.token.equals("POSITION")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] dArray = this.coordPair();
                    return new Region(coordSys, dArray);
                }
                catch (Exception exception) {
                    throw this.buildException(exception, "\"POSITION <coordSys> <coordPair>\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + COORD_SYS_SYNTAX, n);
                }
            }
            if (this.token.equals("CIRCLE")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] dArray = this.coordPair();
                    double d = this.numeric();
                    return new Region(coordSys, dArray, d);
                }
                catch (Exception exception) {
                    throw this.buildException(exception, "\"CIRCLE <coordSys> <coordPair> <radius>\", where coordPair=\"<numeric> <numeric>\", radius=\"<numeric>\" and coordSys=" + COORD_SYS_SYNTAX, n);
                }
            }
            if (this.token.equals("BOX")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] dArray = this.coordPair();
                    double d = this.numeric();
                    double d2 = this.numeric();
                    return new Region(coordSys, dArray, d, d2);
                }
                catch (Exception exception) {
                    throw this.buildException(exception, "\"BOX <coordSys> <coordPair> <width> <height>\", where coordPair=\"<numeric> <numeric>\", width and height=\"<numeric>\" and coordSys=" + COORD_SYS_SYNTAX, n);
                }
            }
            if (this.token.equals("POLYGON")) {
                try {
                    double[] dArray;
                    int n2;
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Double> arrayList = new ArrayList<Double>(6);
                    for (n2 = 0; n2 < 3; ++n2) {
                        dArray = this.coordPair();
                        arrayList.add(dArray[0]);
                        arrayList.add(dArray[1]);
                    }
                    n2 = 1;
                    do {
                        int n3 = this.pos;
                        try {
                            dArray = this.coordPair();
                            arrayList.add(dArray[0]);
                            arrayList.add(dArray[1]);
                        }
                        catch (ParseException parseException) {
                            n2 = 0;
                            this.pos = n3;
                        }
                    } while (n2 != 0);
                    double[][] dArray2 = new double[arrayList.size() / 2][2];
                    for (int i = 0; i < arrayList.size() && i + 1 < arrayList.size(); i += 2) {
                        dArray2[i / 2] = new double[]{(Double)arrayList.get(i), (Double)arrayList.get(i + 1)};
                    }
                    return new Region(coordSys, dArray2);
                }
                catch (Exception exception) {
                    throw this.buildException(exception, "\"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + COORD_SYS_SYNTAX, n);
                }
            }
            if (this.token.equals("UNION") || this.token.equals("INTERSECTION")) {
                RegionType regionType = this.token.equals("UNION") ? RegionType.UNION : RegionType.INTERSECTION;
                try {
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Region> arrayList = new ArrayList<Region>(2);
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("a opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"" + (Object)((Object)regionType) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + COORD_SYS_SYNTAX, n);
                    }
                    ++this.pos;
                    arrayList.add(this.region());
                    arrayList.add(this.region());
                    this.skipSpaces();
                    while (this.stcs.charAt(this.pos) != ')') {
                        arrayList.add(this.region());
                        this.skipSpaces();
                    }
                    ++this.pos;
                    return new Region(regionType, coordSys, arrayList.toArray(new Region[arrayList.size()]));
                }
                catch (Exception exception) {
                    if (exception instanceof ParseException && exception.getMessage().startsWith("Incorrect syntax: \"")) {
                        throw (ParseException)exception;
                    }
                    throw this.buildException(exception, "\"" + (Object)((Object)regionType) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + COORD_SYS_SYNTAX, n);
                }
            }
            if (this.token.equals("NOT")) {
                try {
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("an opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", n);
                    }
                    ++this.pos;
                    Region region = this.region();
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != ')') {
                        throw this.buildException(new ParseException("a closing parenthesis - ) - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", n);
                    }
                    ++this.pos;
                    return new Region(region);
                }
                catch (Exception exception) {
                    if (exception instanceof ParseException && exception.getMessage().startsWith("Incorrect syntax: ")) {
                        throw (ParseException)exception;
                    }
                    throw this.buildException(exception, "\"NOT ( <region> )\"", n);
                }
            }
            throw new ParseException("Unknown STC region type: \"" + this.token + "\"!", new TextPosition(1, n, 1, this.pos));
        }

        private ParseException buildException(Exception exception, String string, int n) {
            if (exception instanceof EOEException) {
                return new ParseException("Unexpected End Of Expression! Expected syntax: " + string + ".", new TextPosition(1, n, 1, this.pos));
            }
            if (exception instanceof ParseException) {
                return new ParseException("Incorrect syntax: " + exception.getMessage() + " Expected syntax: " + string + ".", ((ParseException)exception).getPosition() != null ? ((ParseException)exception).getPosition() : new TextPosition(1, n, 1, this.pos));
            }
            return new ParseException(exception.getMessage(), new TextPosition(1, n, 1, this.pos));
        }

        private static class EOEException
        extends ParseException {
            private static final long serialVersionUID = 1L;

            public EOEException() {
                super("Unexpected End Of Expression!");
            }
        }
    }

    public static class Region {
        public final RegionType type;
        public final CoordSys coordSys;
        public final double[][] coordinates;
        public final double width;
        public final double height;
        public final double radius;
        public final Region[] regions;
        private String stcs = null;
        private String fullStcs = null;
        private GeometryFunction geometry = null;

        public Region(CoordSys coordSys, double[] dArray) {
            this(coordSys, new double[][]{dArray});
        }

        public Region(CoordSys coordSys, double[][] dArray) {
            if (dArray == null || dArray.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (dArray[0].length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected at least 2 pairs of coordinates (so coordinates[0], coordinates[1] and coordinates[n].length = 2).");
            }
            this.type = dArray.length > 1 ? RegionType.POLYGON : RegionType.POSITION;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = dArray;
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.radius = Double.NaN;
            this.regions = null;
        }

        public Region(CoordSys coordSys, double[] dArray, double d) {
            if (dArray == null || dArray.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (dArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
            }
            this.type = RegionType.CIRCLE;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = new double[][]{dArray};
            this.radius = d;
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.regions = null;
        }

        public Region(CoordSys coordSys, double[] dArray, double d, double d2) {
            if (dArray == null || dArray.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (dArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
            }
            this.type = RegionType.BOX;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = new double[][]{dArray};
            this.width = d;
            this.height = d2;
            this.radius = Double.NaN;
            this.regions = null;
        }

        public Region(RegionType regionType, CoordSys coordSys, Region[] regionArray) {
            if (regionType == null) {
                throw new NullPointerException("Missing type of region (UNION or INTERSECTION here)!");
            }
            if (regionType != RegionType.UNION && regionType != RegionType.INTERSECTION) {
                throw new IllegalArgumentException("Wrong region type: \"" + (Object)((Object)regionType) + "\"! This constructor lets create only an UNION or INTERSECTION region.");
            }
            if (regionArray == null || regionArray.length == 0) {
                throw new NullPointerException("Missing regions to " + (regionType == RegionType.UNION ? "unite" : "intersect") + "!");
            }
            if (regionArray.length < 2) {
                throw new IllegalArgumentException("Wrong number of regions! Expected at least 2 regions.");
            }
            this.type = regionType;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.regions = regionArray;
            this.coordinates = null;
            this.radius = Double.NaN;
            this.width = Double.NaN;
            this.height = Double.NaN;
        }

        public Region(Region region) {
            if (region == null) {
                throw new NullPointerException("Missing region to NOT select!");
            }
            this.type = RegionType.NOT;
            this.regions = new Region[]{region};
            this.coordSys = null;
            this.coordinates = null;
            this.radius = Double.NaN;
            this.width = Double.NaN;
            this.height = Double.NaN;
        }

        public Region(GeometryFunction geometryFunction) throws IllegalArgumentException, ParseException {
            if (geometryFunction == null) {
                throw new NullPointerException("Missing geometry to convert into STCS.Region!");
            }
            if (geometryFunction instanceof PointFunction) {
                this.type = RegionType.POSITION;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometryFunction.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((PointFunction)geometryFunction).getCoord1()), Region.extractNumeric(((PointFunction)geometryFunction).getCoord2())}};
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometryFunction instanceof CircleFunction) {
                this.type = RegionType.CIRCLE;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometryFunction.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((CircleFunction)geometryFunction).getCoord1()), Region.extractNumeric(((CircleFunction)geometryFunction).getCoord2())}};
                this.radius = Region.extractNumeric(((CircleFunction)geometryFunction).getRadius());
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.regions = null;
            } else if (geometryFunction instanceof BoxFunction) {
                this.type = RegionType.BOX;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometryFunction.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((BoxFunction)geometryFunction).getCoord1()), Region.extractNumeric(((BoxFunction)geometryFunction).getCoord2())}};
                this.width = Region.extractNumeric(((BoxFunction)geometryFunction).getWidth());
                this.height = Region.extractNumeric(((BoxFunction)geometryFunction).getHeight());
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometryFunction instanceof PolygonFunction) {
                PolygonFunction polygonFunction = (PolygonFunction)geometryFunction;
                this.type = RegionType.POLYGON;
                this.coordSys = STCS.parseCoordSys(Region.extractString(polygonFunction.getCoordinateSystem()));
                this.coordinates = new double[(polygonFunction.getNbParameters() - 1) / 2][2];
                for (int i = 0; i < this.coordinates.length; ++i) {
                    this.coordinates[i] = new double[]{Region.extractNumeric(polygonFunction.getParameter(1 + i * 2)), Region.extractNumeric(polygonFunction.getParameter(2 + i * 2))};
                }
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometryFunction instanceof RegionFunction) {
                Region region = STCS.parseRegion(Region.extractString(((RegionFunction)geometryFunction).getParameter(0)));
                this.type = region.type;
                this.coordSys = region.coordSys;
                this.coordinates = region.coordinates;
                this.width = region.width;
                this.height = region.height;
                this.radius = region.radius;
                this.regions = region.regions;
            } else {
                throw new IllegalArgumentException("Unknown region type! Only geometrical function PointFunction, CircleFunction, BoxFunction, PolygonFunction and RegionFunction are allowed.");
            }
        }

        private static String extractString(ADQLOperand aDQLOperand) throws ParseException {
            if (aDQLOperand == null) {
                throw new NullPointerException("Missing operand!");
            }
            if (aDQLOperand instanceof StringConstant) {
                return ((StringConstant)aDQLOperand).getValue();
            }
            throw new ParseException("Can not convert into STC-S a non string argument (including ADQLColumn and Concatenation)!");
        }

        private static double extractNumeric(ADQLOperand aDQLOperand) throws ParseException {
            if (aDQLOperand == null) {
                throw new NullPointerException("Missing operand!");
            }
            if (aDQLOperand instanceof NumericConstant) {
                return Double.parseDouble(((NumericConstant)aDQLOperand).getValue());
            }
            if (aDQLOperand instanceof NegativeOperand) {
                return Region.extractNumeric(((NegativeOperand)aDQLOperand).getOperand()) * -1.0;
            }
            throw new ParseException("Can not convert into STC-S a non numeric argument (including ADQLColumn and Operation)!");
        }

        public String toSTCS() {
            if (this.stcs != null) {
                return this.stcs;
            }
            StringBuffer stringBuffer = new StringBuffer(this.type.toString());
            if (this.type != RegionType.NOT) {
                String string = this.coordSys.toSTCS();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(' ').append(string);
                }
                stringBuffer.append(' ');
            }
            switch (this.type) {
                case POSITION: 
                case POLYGON: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    break;
                }
                case CIRCLE: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    stringBuffer.append(' ').append(this.radius);
                    break;
                }
                case BOX: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    stringBuffer.append(' ').append(this.width).append(' ').append(this.height);
                    break;
                }
                case UNION: 
                case INTERSECTION: 
                case NOT: {
                    stringBuffer.append('(');
                    Region.appendRegions(stringBuffer, this.regions, false);
                    stringBuffer.append(')');
                }
            }
            this.stcs = stringBuffer.toString();
            return this.stcs;
        }

        public String toFullSTCS() {
            if (this.fullStcs != null) {
                return this.fullStcs;
            }
            StringBuffer stringBuffer = new StringBuffer(this.type.toString());
            if (this.type != RegionType.NOT) {
                String string = this.coordSys.toFullSTCS();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(' ').append(string);
                }
                stringBuffer.append(' ');
            }
            switch (this.type) {
                case POSITION: 
                case POLYGON: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    break;
                }
                case CIRCLE: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    stringBuffer.append(' ').append(this.radius);
                    break;
                }
                case BOX: {
                    Region.appendCoordinates(stringBuffer, this.coordinates);
                    stringBuffer.append(' ').append(this.width).append(' ').append(this.height);
                    break;
                }
                case UNION: 
                case INTERSECTION: 
                case NOT: {
                    stringBuffer.append('(');
                    Region.appendRegions(stringBuffer, this.regions, true);
                    stringBuffer.append(')');
                }
            }
            this.fullStcs = stringBuffer.toString();
            return this.fullStcs;
        }

        private static void appendCoordinates(StringBuffer stringBuffer, double[][] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(dArray[i][0]).append(' ').append(dArray[i][1]);
            }
        }

        private static void appendRegions(StringBuffer stringBuffer, Region[] regionArray, boolean bl) {
            for (int i = 0; i < regionArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                if (bl) {
                    stringBuffer.append(regionArray[i].toFullSTCS());
                    continue;
                }
                stringBuffer.append(regionArray[i].toSTCS());
            }
        }

        public String toString() {
            return this.toSTCS();
        }

        public GeometryFunction toGeometry() {
            return this.toGeometry(null);
        }

        public GeometryFunction toGeometry(ADQLQueryFactory aDQLQueryFactory) {
            if (aDQLQueryFactory == null) {
                aDQLQueryFactory = new ADQLQueryFactory();
            }
            try {
                if (this.geometry != null) {
                    return this.geometry;
                }
                StringConstant stringConstant = aDQLQueryFactory.createStringConstant(this.coordSys == null ? "" : this.coordSys.toString());
                switch (this.type) {
                    case POSITION: {
                        this.geometry = aDQLQueryFactory.createPoint(stringConstant, this.toNumericObj(this.coordinates[0][0], aDQLQueryFactory), this.toNumericObj(this.coordinates[0][1], aDQLQueryFactory));
                        return this.geometry;
                    }
                    case CIRCLE: {
                        this.geometry = aDQLQueryFactory.createCircle(stringConstant, this.toNumericObj(this.coordinates[0][0], aDQLQueryFactory), this.toNumericObj(this.coordinates[0][1], aDQLQueryFactory), this.toNumericObj(this.radius, aDQLQueryFactory));
                        return this.geometry;
                    }
                    case BOX: {
                        this.geometry = aDQLQueryFactory.createBox(stringConstant, this.toNumericObj(this.coordinates[0][0], aDQLQueryFactory), this.toNumericObj(this.coordinates[0][1], aDQLQueryFactory), this.toNumericObj(this.width, aDQLQueryFactory), this.toNumericObj(this.height, aDQLQueryFactory));
                        return this.geometry;
                    }
                    case POLYGON: {
                        ArrayList<ADQLOperand> arrayList = new ArrayList<ADQLOperand>(this.coordinates.length * 2);
                        for (int i = 0; i < this.coordinates.length; ++i) {
                            arrayList.add(this.toNumericObj(this.coordinates[i][0], aDQLQueryFactory));
                            arrayList.add(this.toNumericObj(this.coordinates[i][1], aDQLQueryFactory));
                        }
                        this.geometry = aDQLQueryFactory.createPolygon(stringConstant, arrayList);
                        return this.geometry;
                    }
                }
                this.geometry = aDQLQueryFactory.createRegion(aDQLQueryFactory.createStringConstant(this.toString()));
                return this.geometry;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private ADQLOperand toNumericObj(double d, ADQLQueryFactory aDQLQueryFactory) throws Exception {
            if (d >= 0.0) {
                return aDQLQueryFactory.createNumericConstant("" + d);
            }
            return aDQLQueryFactory.createNegativeOperand(aDQLQueryFactory.createNumericConstant("" + d * -1.0));
        }
    }

    public static enum RegionType {
        POSITION,
        CIRCLE,
        BOX,
        POLYGON,
        UNION,
        INTERSECTION,
        NOT;

    }

    public static class CoordSys {
        public final Frame frame;
        public final RefPos refpos;
        public final Flavor flavor;
        private final boolean isDefault;
        private final String stcs;
        private final String fullStcs;

        public CoordSys() {
            this(null, null, null);
        }

        public CoordSys(Frame frame, RefPos refPos, Flavor flavor) throws IllegalArgumentException {
            this.frame = frame == null ? Frame.DEFAULT : frame;
            this.refpos = refPos == null ? RefPos.DEFAULT : refPos;
            Flavor flavor2 = this.flavor = flavor == null ? Flavor.DEFAULT : flavor;
            if (this.flavor != Flavor.SPHERICAL2 && (this.frame != Frame.UNKNOWNFRAME || this.refpos != RefPos.UNKNOWNREFPOS)) {
                throw new IllegalArgumentException("a coordinate system expressed with a cartesian flavor MUST have an UNKNOWNFRAME and UNKNOWNREFPOS!");
            }
            this.isDefault = this.frame.isDefault() && this.refpos.isDefault() && this.flavor.isDefault();
            this.stcs = ((!this.frame.isDefault() ? (Object)((Object)this.frame) + " " : "") + (!this.refpos.isDefault() ? (Object)((Object)this.refpos) + " " : "") + (!this.flavor.isDefault() ? this.flavor : "")).trim();
            this.fullStcs = (Object)((Object)this.frame) + " " + (Object)((Object)this.refpos) + " " + (Object)((Object)this.flavor);
        }

        public CoordSys(String string) throws ParseException {
            CoordSys coordSys = new STCSParser().parseCoordSys(string);
            this.frame = coordSys.frame;
            this.refpos = coordSys.refpos;
            this.flavor = coordSys.flavor;
            this.isDefault = coordSys.isDefault;
            this.stcs = coordSys.stcs;
            this.fullStcs = coordSys.fullStcs;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public String toSTCS() {
            return this.stcs;
        }

        public String toFullSTCS() {
            return this.fullStcs;
        }

        public String toString() {
            return this.stcs;
        }
    }

    public static enum Flavor {
        CARTESIAN2,
        CARTESIAN3,
        SPHERICAL2;

        public static final Flavor DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = SPHERICAL2;
            regexp = STCS.buildRegexp(Flavor.class);
        }
    }

    public static enum RefPos {
        BARYCENTER,
        GEOCENTER,
        HELIOCENTER,
        LSR,
        TOPOCENTER,
        RELOCATABLE,
        UNKNOWNREFPOS;

        public static final RefPos DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNREFPOS;
            regexp = STCS.buildRegexp(RefPos.class);
        }
    }

    public static enum Frame {
        ECLIPTIC,
        FK4,
        FK5,
        GALACTIC,
        ICRS,
        UNKNOWNFRAME;

        public static final Frame DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNFRAME;
            regexp = STCS.buildRegexp(Frame.class);
        }
    }
}

