/*
 * Decompiled with CFR 0.152.
 */
import cds.aladin.AladinData;
import cds.aladin.AladinPlugin;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.RepereSpectrum;
import cds.aladin.SourceStat;
import cds.tools.VOApp;
import cds.tools.VOObserver;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class PhotControlPlug
extends AladinPlugin
implements VOObserver,
VOApp {
    static String planeName = "PhotTool";
    AladinData ad = null;
    HashMap<Obj, Integer> alreadyScanned = new HashMap();

    @Override
    public String menu() {
        return "Photometry tool manipulation";
    }

    @Override
    public String description() {
        return "PLUGIN TUTORIAL:\nThis plugin is an example for photometry tools manipulation.\nThis plugin extracts the spectrum at the mouse position.";
    }

    @Override
    public String version() {
        return "1.1 - Octobre 2021 -  - required Aladin >= v11.069";
    }

    @Override
    public String author() {
        return "Pierre Fernique [CDS]";
    }

    @Override
    public String url() {
        return "http://aladin.cds.unistra.fr/java/Plugins/PhotControlPlug.java";
    }

    @Override
    public void exec() {
        this.aladin.addObserver(this, 28);
        String statList = this.aladin.setStatMask("-median,-pixels");
        System.out.println("Statistics: " + statList);
        try {
            this.ad = this.getOrCreateToolPlane();
            System.out.println("The phot tools must be stored in \"" + this.ad.getLabel() + "\" tool plane");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AladinData getOrCreateToolPlane() throws Exception {
        String[] planeID = this.aladin.getAladinStack();
        for (int i = 0; i < planeID.length; ++i) {
            AladinData sd = this.aladin.getAladinData(planeID[i]);
            if (sd.getPlaneType().indexOf("Tool") < 0) continue;
            return sd;
        }
        return this.aladin.createAladinTool(planeName);
    }

    @Override
    public String execCommand(String cmd) {
        System.out.println("Aladin event: => " + cmd);
        this.rescanPhotTool();
        return "";
    }

    private void rescanPhotTool() {
        try {
            AladinData adbg = this.aladin.getAladinImage();
            String planeType = adbg.getPlaneType();
            System.out.println("Phot stats from " + adbg.getLabel() + " plane (" + planeType + ")...");
            boolean isCube = planeType.indexOf("Blink") >= 0 || planeType.indexOf("Cube") >= 0;
            HashMap<Obj, Integer> scanned = new HashMap<Obj, Integer>();
            Iterator<Obj> it = this.ad.iteratorObj();
            while (it.hasNext()) {
                double[] raDecVal;
                Obj o = it.next();
                if (!o.hasPhot() || !o.isVisible()) continue;
                int cle = o.getStatsHashcode(adbg);
                scanned.put(o, cle);
                Integer lastCle = this.alreadyScanned.get(o);
                if (lastCle != null && lastCle == cle) {
                    System.out.println("Obj " + o.hashCode() + " stats already known");
                    continue;
                }
                double[] stats = o.getStatistics(adbg);
                if (stats == null) continue;
                String type = o instanceof Ligne ? "polygon" : (o instanceof SourceStat ? "circle" : (o instanceof RepereSpectrum ? "point" : "Other??"));
                System.out.println("Obj " + type + " hash=" + o.hashCode() + "=>  cnt=" + stats[0] + ",sum=" + stats[1] + ",sigma=" + stats[2] + ",surf=" + stats[3] + ",min=" + stats[4] + ",max=" + stats[5]);
                if (isCube) {
                    int z = adbg.getDepth();
                    stats = o.getStatistics(adbg, z / 2);
                    System.out.println("      middle frame (" + z / 2 + "): =>  cnt=" + stats[0] + ",sum=" + stats[1] + ",sigma=" + stats[2] + ",surf=" + stats[3] + ",min=" + stats[4] + ",max=" + stats[5]);
                    stats = o.getStatistics(adbg, z - 1);
                    System.out.println("      last frame (" + (z - 1) + ") : =>  cnt=" + stats[0] + ",sum=" + stats[1] + ",sigma=" + stats[2] + ",surf=" + stats[3] + ",min=" + stats[4] + ",max=" + stats[5]);
                    long cnt = 0L;
                    long t = System.currentTimeMillis();
                    for (int i = 0; i < z; ++i) {
                        stats = o.getStatistics(adbg, i);
                        if (i % 100 == 0) {
                            System.out.println("stat " + i + "...");
                        }
                        cnt = (long)((double)cnt + stats[0]);
                    }
                    long t1 = System.currentTimeMillis();
                    System.out.println("Extract statistics for " + cnt + " pixels through " + z + " frames (" + cnt / (long)z + " per frame) in " + (t1 - t) + "ms => " + (double)(t1 - t) / (double)z + "ms per frame");
                }
                if ((raDecVal = o.getStatisticsRaDecPix(adbg, 0)).length <= 0) continue;
                int i = 0;
                System.out.println("First pixel " + i / 3 + " (frame 0) ra=" + raDecVal[i] + " dec=" + raDecVal[i + 1] + " pix=" + raDecVal[i + 2]);
                i = raDecVal.length - 3;
                System.out.println("Last pixel  " + i / 3 + " (frame 0) ra=" + raDecVal[i] + " dec=" + raDecVal[i + 1] + " pix=" + raDecVal[i + 2]);
            }
            for (Obj o : this.alreadyScanned.keySet()) {
                if (scanned.containsKey(o)) continue;
                System.out.println("Obj " + o.hashCode() + " has been removed in Aladin");
            }
            this.alreadyScanned = scanned;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String putVOTable(InputStream in, String label) {
        return null;
    }

    @Override
    public String putVOTable(VOApp app, InputStream in, String label) {
        return null;
    }

    @Override
    public InputStream getVOTable(String dataID) {
        return null;
    }

    @Override
    public String putFITS(InputStream in, String label) {
        return null;
    }

    @Override
    public InputStream getFITS(String dataID) {
        return null;
    }

    @Override
    public void showVOTableObject(String[] oid) {
    }

    @Override
    public void selectVOTableObject(String[] oid) {
    }

    @Override
    public void setVisible(boolean flag) {
    }

    @Override
    public void addObserver(VOObserver app, int eventMasq) {
    }

    @Override
    public void pixel(double pixValue) {
    }

    @Override
    public void position(double raJ2000, double deJ2000) {
    }
}

