/*
 * Decompiled with CFR 0.152.
 */
import cds.aladin.AladinData;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.tools.VOObserver;

public class CubeManipulationPlug
extends AladinPlugin
implements VOObserver {
    @Override
    public String menu() {
        return "Spectrum extraction from a cube";
    }

    @Override
    public String description() {
        return "PLUGIN TUTORIAL:\nThis plugin is an example a cube manipulation.\nThis plugin extracts the spectrum at the mouse position.";
    }

    @Override
    public String category() {
        return "Plugin tutorial/Cube";
    }

    @Override
    public String version() {
        return "1.0 - January 2007";
    }

    @Override
    public String author() {
        return "Pierre Fernique [CDS]";
    }

    @Override
    public String url() {
        return "http://aladin.cds.unistra.fr/java/Plugins/CubeManipulationPlug.java";
    }

    @Override
    public void exec() {
        this.aladin.addObserver(this, 1);
    }

    @Override
    public void position(double ra, double dec) {
        try {
            AladinData ad = this.aladin.getAladinData();
            String planeType = ad.getPlaneType();
            if (!planeType.equals("Image/Cube")) {
                System.out.println("Only Image/Cube is supported");
                return;
            }
            double[] xy = ad.getXY(ra, dec);
            int X = (int)(xy[0] - 0.5);
            int Y = (int)(xy[1] - 0.5);
            int depth = ad.getDepth();
            double[][][] cube = ad.getCube(X, Y, 0, 1, 1, depth);
            System.out.print("First 20th spectrum values at (" + X + "," + Y + ") : ");
            for (int i = 0; i < Math.min(20, depth); ++i) {
                System.out.print(" " + cube[0][0][i]);
            }
            System.out.println();
        }
        catch (AladinException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pixel(double pixValue) {
    }
}

