
UBCONE                                                         10DEC2003

NAME: ubcone
-----

SYNOPSIS: extract a subset from the USNO-B catalogue
---------

USAGE: ubcone + options
------

VERSION:
--------
  1.5 (10DEC2003)

SHORT DESCRIPTION OF OPTIONS
----------------------------

 Option Description                      Default
 ------ -----------                      -------
 -B     Field Name                       "Field"

 -F     RegionType  (R, C, B)                  R
		(R=Rectangle,C=Circle,B=DecBand)
 -h     to get this help output
 -H     to get this help output

 -I     Bright Magnitude                     0.0
 -i     Faint Magnitude                    100.0

 -L     Primary Sort Color (B1 R1 B2 R2 I2)   R2

 -O     Output File Name Root              "Tmp"

 -P     RA(hrs)                              0.0
 -p     DEC(deg)                             0.0

 -Q     Turn on Binary -> Ascii Dump Mode

 -S     RA Width/Circle Radius(deg)          0.166667
 -s     Dec Width(deg)                       0.166667

 -Z     Output Format (S M L)                  M
          (S=Small, M=Medium, L=Large/all fields)
 -z     output file sort key (N R D M C L)     N
          (Sort in N=none, R=RA, D=Dec, M=Mag, C=Color, L=Dist. to Center)

LONG DESCRIPTION OF OPTIONS
---------------------------

 -B Field Name.  Default: "Field".  This option allows the user to
	enter an arbitrary identifying string.  The string will be
	included in the header of the output catalogue.

 -F Type of Region to extract. Default: R = Rectangle.  This flag
	selects the type of region to extract from the original
	catalogue.  The options are R = Rectangle, C = Circle, and B =
	DecBand.  The rectangular region is specified by a region
	center (set by the -P and -p options), and a width and height
	(set by the -S and -s options).  The circular region is
	specified by a region center (set by the -P and -p options),
	and a radius (set by the -S option).  The declination band is
	specified by a region center (set by the -P and -p options),
	and a height (set by the -s option).  The center is specified
	in hours and degrees and the sizes are specified in decimal
	degrees.

 -H Causes the program to print out single page summary of the
        command line options.

 -h Causes the program to print out single page summary of the
        command line options.

 -I Bright Magnitude Limit. Default: 0.0.  This options sets the limit
        on how bright an object will be included in the returned
        catalogue.  All stars fainter than this limit will be
        returned.  The allowed range is -1.0 to 100.0 magnitudes.  The
        magnitude used for this selection is set by the -L option.

 -i Faint Magnitude Limit. Default: 100.0.  This options sets the limit
        on how faint an object will be included in the returned
        catalogue.  All stars brighter than this limit will be
        returned.  The allowed range is -1.0 to 100.0 magnitudes.  The
        magnitude used for this selection is set by the -L option.

 -L Select the Primary Selection Color.  Default: R2 (second epoch
        red).  This option selects the magnitude to be used for
        magnitude limiting cuts (set by the -I and -i options).  The
        allowed values are B1, R1, B2, R2, and I2; these correspond to
        the first epoch blue, and red magnitudes, and the second epoch
        blue, red and near-IR magnitudes respectively.
    
 -O Set the root of the Output File Name.  Default: Tmp.  This option
        allows the user to set the root of the output file name(s).
        All names will have _usnob and a 3 letter extension appended
        (depending upon the file type).  For example, an ascii version
        of an output catalogue using the default root would be called
        Tmp_usnob.asc.  The file type is set by the -o option.
    
 -P Set the Right Ascension (RA) of the center of the region to be
        extracted.  This is done in decimal hours.  Default: 0.0.
        This option allows the user to specify the RA of the center of
        a region to be extracted.  The option is ignored for all-sky
        and declination band extractions.  The allowed range of values
        is 0.0 to 24.0 hours.
    
 -p Set the Declination (DEC) of the center of the region to be
        extracted.  This is done in decimal degrees.  Default: 0.0.
        This option allows the user to specify the DEC of the center
        of a region to be extracted.  The option is ignored for
        all-sky extractions.  The allowed range of values is -90.0 to
        +90.0 degrees.

 -Q Turn on Binary -> Ascii Dump Mode.  This is a specialize flag
 	specifically added for turning a binary version of USNO-B into, 
	an ascii copy.  It not meant for general use.

 -S Set the Width in Right Ascension or Radius of the Circle for a
        region extraction.  If the extraction is a rectangle, this
        will be the width in RA, if it is a circle, this is the circle
        radius.  This dimension is given in decimal degrees of arc.
        Default: 0.166667 deg (which equals 10 arcminutes).  The
        allowed range of values is 0.0 to 10.0 degrees (= 2/3 hour)(this
        can be reset in the code).
    
 -s Set the Declination Height for a region extraction.  This applies
        to rectangular regions, and declination bands.  This dimension
        is given in decimal degrees of arc.  Default: 0.166667 deg
        (which equals 10 arcminutes).  The allowed range of values is
        0.0 to 10.0 degrees (this can be reset in the code).
    
 -Z Select the Output Format for the catalogue.  This option selects
        how much of the information in the original catalogue is
        copied to the new catalogue.  Default: M (=Medium).  The
        allowed options are S = Small, M = Medium, and L = Large/all
        fields.  
        In the Short option, the columns include:
          ID, 
	  Right Ascension (RA), 
	  Declination (Dec), 
	  RA error, 
	  Dec error,
	  RA Proper Motion, 
	  Dec Proper Motion, 
	  RA Proper Motion error,
	  Dec Proper Motion error, 
	  Number of points in the position fit, 
	  all magnitudes, 
	  any flagbits,

	The Medium option includes all of the columns from the short
	option, and the following additional columns:
	  Mean Epoch of observations of an object,
	  Probability associated with the proper motion,
	  RA Errors on the Fit,
	  Dec Errors on the Fit,
	  Star/Galaxy index with each magnitude measurement,
	  Xi* (if the region is circular or rectangular),
	  Eta* (if the region is circular or rectangular).
    
	* = values are NOT in the original catalogue, they are
	    computed for this region, based on the region center, and
	    each object's position.

	The Large option includes all of the columns from the medium
	option, and the following additional columns (it actually
	includes all the columns from the original catalogue):
	  any flags associated specifically with each magnitude,
	  the field and survey identifier for each magnitude,
	  the xi and eta residuals for each measured position,
	  the lookup index for each measurement in the raw detection lists.

 -z Select output file sort key.  Default: N (= none).  This option
        allows the user to request that the output catalogue be sorted
        in one of the following ways:
	  N = none, means don't sort the catalogue.  The new catalogue
              will be in the order that the data were extracted from
              the original catalogue.
	  R = sort the new catalogue in Right Ascension.
	  D = sort the new catalogue in Declination.
	  M = sort the new catalogue by Magnitude.  The magnitude used
              is the one selected by the -L option.
	  L = sort the catalogue by distance from the region center.
	      This is only appropriate for rectangular and circular
	      regions. 

DESCRIPTION:
------------

  Ubcone is a command line driven program to extract a subset from the
USNO-B catalogue.  The subset parameters are given by the command line
options.  The parameters are combined using a logical AND (ie, for an
object to be included in the catalogue, it must satisfy all the listed
criteria).  This subset tool is set to apply the criteria to a region
that can be rectangular, or circular.  In this version, the subset size
is limited to 250,000 objects (this can be expanded).

  The user should set the environment variable USNOBDIR so that ubcone
knows where to find the directory tree with the catalogue.  If you are
using the c-shell (tcsh, or csh) and the catalogue lives under /cat/usnob,
this is done as:
      setenv USNOBDIR /cat/usnob

SAMPLE EXTRACTIONS:
-------------------

  To extract a circular subset around the point RA=1hour, DEC=-20deg,
that has a radius of 0.1 degrees, and has all stars between R2
magnitude 10 and 14 and place the output into the file sample_usnob, 
the command would be:

 prompt> ubcone -P 1.0 -p -20.0 -S 0.1 -F C -L R2 -O sample

Any flag not given on the command line will be filled in with the
default value as given above in the table of options.

The output file will be called sample1_usnob.asc (the _usnob and .asc
get added to your name to indicate the cataloge, and that the file is
flat ascii).   The file will have a header with your search
parameters:

FIELD   = 'Field'                      /Field Name                           
CAT_ID  = 'USNOB'                      /Catalogue ID                         
NOBJECTS= 36                           /Number of Objects In File            
EQUINOX = J2000.0 2000.00              /Equinox, Epoch                       
RA      = 1.000000                     /Center RA  [hrs]                     
DEC     = -20.000000                   /Center DEC [deg]                     
RADIUS  = 0.050000                     /Circle Radius [deg]                  
MAGNITUD= 'R2'                         /Primary Sort Color                   
BR_MAG  = 0.00                         /Bright Magnitude Limit [mag]         
FT_MAG  = 25.00                        /Faint Magnitude Limit [mag]          
COLOR   = 'B2-R2'                      /Color0 minus Color1 (C0-C1)          
BR_MIN  = -20.00                       /Color Limit: Min. C0-C1 [mag]        
BR_MAX  = 20.00                        /Color Limit: Max. C0-C1 [mag]        
MU_MIN  = 0.00                         /Min. Proper Motion [mas/yr]          
MU_MAX  = 10000.00                     /Max. Proper Motion [mas/yr]          
SPOS_MIN= 0.00                         /Min. Position Error [mas]            
SPOS_MAX= 10000.00                     /Max. Position Error [mas]            
SMU_MIN = 0.00                         /Min. Proper Motion Error [mas/yr]    
SMU_MAX = 10000.00                     /Max. Proper Motion Error [mas/yr]    
SD_MAX  = 10000000.00                  /Maximum Surface Density [N/deg^2]    
SEP_MIN = 0.000000                     /Minimum Separation [deg]             
END                                                                          

Followed by 2 lines of column headings, and then one line per object.
(The lines were wrapped for this document, but are NOT wrapped in the
real file.)

line 1
          id|         RA|        DEC|sra|sde|         Epoch|  MuRA|
          MuDEC|MuProb| sMuRA| sMuDE|sFitRA|sFitDE|NFitPt| Flags|
              B1|S/G|     R1|S/G|     B2|S/G|     R2|S/G|     I2|S/G|
          Xi|         Eta|

line 2
          nd|     hh.hhh|     dd.ddd|mas|mas|     yyyy.yyyy|mas/yr|
	  mas/yr|   nd|mas/yr|mas/yr|   mas|   mas|    nd|    nd|
	     mag| nd|    mag| nd|    mag| nd|    mag| nd|    mag| nd|
          arcsec|  arcsec|

first object
           1 00.99770222 -20.0141778  57  58    1975.800000    -13
           -5      9      1      1      0      0      5      0  15.910
           7  14.860   8  16.760   1  14.990   8  14.550  19
           -116.587      -51.052 

DESCRIPTION OF THE CATALOGUE:
-----------------------------

  See Table 3 of the Astronomical Journal Paper ``The USNO-B Catalog''
by D. Monet et al. for a complete byte by byte description of the
original BINARY catalogue format.

  The ASCII version of the extracted subset of the USNO-B catalogue
contains the following fields:

 1) id - identification number.  This number takes on one of two
	 possible values: it is either a running index in this
	 extraction, or if the star is a salted in Tycho2 star, this
	 is the Tycho2 star id.  They Tycho2 ids are given in the form
	 AAAA-BBBBB-C where AAAA = TYC1 (the GSC region number), BBBBB
	 = TYC2 (a running number in the region), and C = TYC3 (a
	 component number).

 2) RA - the Right Ascension of the object in decimal hours.  The
	 epoch and equinox are those given in the file header.  The
	 default is equinox and epoch J2000.0.

 3) DEC - the Declination of the object in decimal degrees.  The epoch
	 and equinox are those given in the file header.  The default
	 is equinox and epoch J2000.0.

 4) sra - the error in the RA position.  This is given in integer
         milli-arcseconds.

 5) sde - the error in the DEC position.  This is given in integer
         milli-arcseconds.

 6) Epoch - this is the mean epoch of all the observations that went
	 into determining the position of this object.  This is given
	 in decimal years.

 7) MuRa - the proper motion in RA.  This is given in angular velocity
         units of milli-arcseconds per year.
	 [This equals MuRA = d(RA)/dt x cos(DEC)]

 8) MuDec - the proper motion in DEC.  This is given in angular velocity
         units of milli-arcseconds per year.

 9) MuProb - a probability estimator for the likelihood that the
	 proper motion is correct.  The range in the original
	 catalogue is 0.0 to 0.9, with higher numbers meaning greater
	 probability of being correct.  The ascii version gives this
	 in the range 0 to 9 (ie, 10 times the decimal version, so 
	 1 = 0.1 etc.).

10) sMuRA - the error in the proper motion in RA.  Given in angular
         velocity units of milli-arcseconds per year. 

11) sMuDE - the error in the proper motion in DEC.  Given in angular
         velocity units of milli-arcseconds per year. 

12) sFitRA - the overall error in the fit in the RA components.  In
	 the original catalogue, this is given as a value between 0.0
	 and 0.9 arcseconds, in steps of 0.1.  The ascii version
	 translates that into integer milli-arcseconds, so the range
	 is 0 to 900 milli-arcseconds, in steps of 100
	 milli-arcseconds.

13) sFitDE - the overall error in the fit in the DEC components.  In
	 the original catalogue, this is given as a value between 0.0
	 and 0.9 arcseconds, in steps of 0.1.  The ascii version
	 translates that into integer milli-arcseconds, so the range
	 is 0 to 900 milli-arcseconds, in steps of 100
	 milli-arcseconds.

14) NFitPt - the number of observations used in the fit for the
         position.  The minimum will be 2, and the maximum will be 5
         (since there are at most 5 separate surveys in which an
         object can be found).  This can be a very useful discriminant
         as to how good an object's information is likely to be.  If
         this has a value of 0, then that means that this object has
         been salted in from the Tycho2 catalogue.

15) Flags - this column merges four pieces of information.  They are
         indicated as individual bits in this integer.  The values
         are:
	   1 = indicates proximity to a proper motion catalogue star
	       (catalogues include LHS, NLTT, Giclas etc.)
	   2 = indicates proximity to a diffraction spike or a bright
	       star (ie a Tycho2 star)
	   4 = indicates that this star is a YS4.0 star.  (YS4.0 was
               the intermediate catalogue used to link the Schmidt
	       plate detections to the Tycho2 astrometric reference
               frame.) 
	   8 = indicates that this star is a Tycho2 star that has been
               salted into the catalogue.
         So, if the flag is 5, this means that the star is near a
         known proper motion catalogue star, and is also in YS4.0.

16) B1 - first epoch blue magnitude.  This is the magnitude derived
         from the POSS-I 103aO plate.  The valid magnitudes should
         span ~0 to ~22 magnitude.  The formal valid range is 0.00 to
         99.99.  If the star was copied in from Tycho2, then this
         value has been computed from the Tycho2 BT and VT magnitudes,
         using relations derived by A. Henden.

17) MagFlg - this gives the photometric calibration source.  0 = the
         bright photometric standards on the plate.  1 = the faint
         photometric standards on this plate. 2 = the faint
         photometric standards 1 plate away (ie, on an overlapping
         plate).  3 = the faint photometric standards 2 plates
         away. And so forth.

18) FldID - this field encodes both the survey, and the field id
         within the survey that corresponds to this observation.  This
         is a 4 digit field, patterned SFFF, where S is the survey id,
         and FFF the field id.  Survey id's are:
	   0 = POSS-I O
	   1 = POSS-I E
           2 = POSS-II J
           3 = POSS-II F
           4 = SERC-J or SERC-EJ
	   5 = ESO-R or SERC-ER
	   6 = AAO-R
	   7 = POSS-II N
	   8 = SERC-I
	   9 = POSS-N field, taken as part of SERC-I

19) S/G - this field is the star/galaxy index.  This is a measure of
         the similarity of the detection to a stellar point spread
         function.  The range is from 0 to 11. 0 means quite
         dissimilar, 11 means very similar.  19 means that there was
         no value computed.

20) XResid - the Xi residual in the tangent plane between the measured
	 position on this plate, and the position computed from the
	 best fit.  This is given as a value in decimal arcseconds
	 between -50.00 and +49.99 arcseconds.

21) YResid - the Xi residual in the tangent plane between the measured
	 position on this plate, and the position computed from the
	 best fit.  This is given as a value in decimal arcseconds
	 between -50.00 and +49.99 arcseconds.

22) PltIdx - the look back index into the PMM raw scan files.

23) R1 - first epoch red magnitude.  This is the magnitude derived
         from the POSS-I 103aE or ESO-R plate.  See (16).

24) MagFlg - see (17)
25) FldID  - see (18)
26) S/G    - see (19)
27) XResid - see (20)
28) YResid - see (21)
29) PltIdx - see (22)

30) B2 - second epoch blue magnitude.  This is the magnitude derived
         from the POSS-II IIIaJ or SERC-J or SERC-EJ plate.  See (16).

31) MagFlg - see (17)
32) FldID  - see (18)
33) S/G	   - see (19)
34) XResid - see (20)
35) YResid - see (21)
36) PltIdx - see (22)

37) R2 - second epoch red magnitude.  This is the magnitude derived
         from the POSS-II IIIaF or AAO-R or SERC-ER plate.  See (16).

38) MagFlg - see (17)
39) FldID  - see (18)
40) S/G	   - see (19)
41) XResid - see (20)
42) YResid - see (21)
43) PltIdx - see (22)

44) I2 - second epoch near-IR magnitude.  This is the magnitude
         derived from the POSS-II IV-N or SERC-I plate.  See (16).

45) MagFlg - see (17)
46) FldID  - see (18)
47) S/G	   - see (19)
48) XResid - see (20)
49) YResid - see (21)
50) PltIdx - see (22)

(*) = computed quantities.

51) Xi (*) - the standard coordinate Xi, in the tangent plane
         projection about the requested region center.  This is only
         computed for rectangular or circular regions.  The units are
         decimal arcseconds.

52) Eta (*) - the standard coordinate Eta, in the tangent plane
         projection about the requested region center.  This is only
         computed for rectangular or circular regions.  The units are
         decimal arcseconds.

53) DistCtr (*) - distance to extraction center in arcseconds.


POSSIBLE VARIABLES TO MODIFY IN THE CODE:
----------------------------------------- 

 1) If you wish to increase the maximum size of a subset that the tool
will extract, edit ubsquare.h, and change the value set for MAXUBSTARS
to whatever value you think appropriate (within the limits that your
machine has the necessary memory to handle this).  For example, to
increase the limit from 250,000 to 2,000,000 edit ubsquare.h and
change:
from
      #define MAXUBSTARS  250000
to
      #define MAXUBSTARS 2000000

 2) To change the maximum allowed ra and dec ranges for the extraction
box, you will need to modify the values on the following line in
ubc_opts.c.  The current maximum box is 4 x 4 degrees, except for a Dec
Band extraction, for which the limits are 4 x 360 degrees.  To change
the limits for a box to 10 x 10 degrees, change the line from:
  #define UBC_MAXBOX   4.0
  #define UBC_MAXBND 360.0
to:
  #define UBC_MAXBOX  10.0
  #define UBC_MAXBND 360.0

 3) To change the default path for USNO-B, edit ubsquare.h and change
the value for BPATH. 

So to change to /newpath/usnob:

from:
  #ifdef V_USAF
  #define BPATH "/cat/usnob/"
  #else
  #define BPATH "/ig7/sel/PixServe/Catalogues/USNOB/"
  #endif
to
  #ifdef V_USAF
  #define BPATH "/cat/usnob/"
  #else
  #define BPATH "/newpath/usnob/"
  #endif

INSTALLATION INSTRUCTIONS:
--------------------------

  This code has been test on the following operating systems:
   - DEC OSF 4.0D using the native Digital C compiler (/bin/cc)
   - Red Hat Linux 7.3, with kernel 2.4.18-3, and the GNU C compiler
     (gcc) version 2.96 20000731
   - Red Hat Linux 7.3, with kernel 2.4.20, and the GNU C compiler
     (gcc) version 2.96 20000731

  To install the cone search tool, you will need an ANSI C compiler and
linker and preferably a version of make.

  1) Log in as the user who will own the cone search tool.
  2) Make a subdirectory and put the gzipped tar file in it (UBC.tgz).
  3) cd to the new directory.
  4) Unpack the distribution file:
	tar xvfz UBC.tgz
     or
	gunzip -c UBC.tgz | tar xvf -
  5) clean up and then make the cone search tool
   a) ln -s Makefile.ubcone.linux Makefile
   b) make clean  (this should call an error, as there should not be
   				anything to clean up)
   c) make all
      This should produce the following output:

picacho 289 >make all
make slab
make[1]: Entering directory `/home/sel/Pmm/USNOB/Cone'
cd Sla_bit; make
make[2]: Entering directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
gcc -O3   -c -o dcs2c.o dcs2c.c
gcc -O3   -c -o dranrm.o dranrm.c
gcc -O3   -c -o ds2tp.o ds2tp.c
gcc -O3   -c -o dsep.o dsep.c
gcc -O3   -c -o dtp2s.o dtp2s.c
make lib
make[3]: Entering directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
Loading ..//sla_bit.a ...  done
make[3]: Leaving directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
make[2]: Leaving directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
make[1]: Leaving directory `/home/sel/Pmm/USNOB/Cone'
make ubcone
make[1]: Entering directory `/home/sel/Pmm/USNOB/Cone'
gcc -DDEBUG -DSTANDALONE -O3   -c -o cio.o cio.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o ubc_eatit.o ubc_eatit.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o ubc_opts.o ubc_opts.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o ubc_saveit.o ubc_saveit.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o ub_xyrcrnrc.o ub_xyrcrnrc.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o ubc_usnob.o ubc_usnob.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o columnbits.o columnbits.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o coord2.o coord2.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o match.o match.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o pixmalloc.o pixmalloc.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o prep_cat.o prep_cat.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o rcpttime.o rcpttime.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o roi_minmax.o roi_minmax.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o sort.o sort.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o srchinfo.o srchinfo.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o struct_cp.o struct_cp.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o timeconv.o timeconv.c
gcc -DDEBUG -DSTANDALONE -O3   -c -o wr_starcat.o wr_starcat.c
gcc -DDEBUG -DSTANDALONE -O3 -c ubcone.c
gcc -DDEBUG -DSTANDALONE -O3 -o .//ubcone ubcone.o cio.o ubc_eatit.o
		ubc_opts.o ubc_saveit.o ub_xyrcrnrc.o ubc_usnob.o 
		columnbits.o coord2.o match.o pixmalloc.o
		prep_cat.o rcpttime.o roi_minmax.o sort.o srchinfo.o 
		struct_cp.o timeconv.o wr_starcat.o ./sla_bit.a -lm -lc
make[1]: Leaving directory `/home/sel/Pmm/USNOB/Cone'
make clean
make[1]: Entering directory `/home/sel/Pmm/USNOB/Cone'
cd Sla_bit; make clean
make[2]: Entering directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
rm *.o
make[2]: Leaving directory `/home/sel/Pmm/USNOB/Cone/Sla_bit'
rm *.o *.a
make[1]: Leaving directory `/home/sel/Pmm/USNOB/Cone'
picacho 290 > 

The tool will be called ubcone, and should be ready to run.

A quick test is to try running the cone search tool with no arguments. You
should get the help page.

prompt> ./ubcone

AUTHOR: S. Levine (USNO Flagstaff Station)
DATE:   10 December 2003 (LAST MODIFIED)
	05 February 2003 (ORIGINAL)
