/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

/* ubcone - simple cone/rectangle search on USNO-B1.0 catalogue */
/*  S. Levine (sel@nofs.navy.mil) */
/* last modified: 05 Feb 2003 */

#include "./ubsquare.h"

int main (int argc, char *argv[])
{
  char *sbrtnname = {"ubcone"};

  PIXREGION *pixr;
  PIXREGION *ubc_cmdline(int, char **);
  STARCAT   *sc;
  STARCAT   *prep_cat (char *catalog,int max_cat_pts,int magcols,int colbits);
  char      sv1[256], cdate[26];
  int       j, k, colbits;
  time_t    tti;
  int       ttu;

  pixr = ubc_cmdline ( argc, argv ); /* parse the command line */

  colbits = 0 | (  CB_CATID0 | CB_CATID1
		 | CB_RADEC  | CB_SRADEC 
		 | CB_EPOCH  
		 | CB_MU     | CB_MUPROB | CB_SMU
		 | CB_SFIT   | CB_FITPTS 
		 | CB_FLG
		 | CB_MAG    | CB_MFLG   | CB_FLDID | CB_SG  | CB_SVY 
		 | CB_XYRES  | CB_PLTIDX
		 | CB_XIETA
		 );

/* alloc space for catal */
  sc = prep_cat ("USNOB", MAXUBSTARS, 5, colbits);

/* setup magnitude names */
  sprintf(sc->magid[0], "%s", "B1");
  sprintf(sc->magid[1], "%s", "R1");
  sprintf(sc->magid[2], "%s", "B2");
  sprintf(sc->magid[3], "%s", "R2");
  sprintf(sc->magid[4], "%s", "I2");

/* unused - file descriptor for binary dump */
  b_fd = 0;

/* time stamp */
  rcpttime2 (&tti, &ttu, cdate);
  fprintf (stderr, "before extraction %s\n", cdate);

/* read in usnob */
  if ((k = rdusnobc ( &(pixr[0]), sc )) < 0) {
    fprintf (stderr, "%s: error opening usnob\n", sbrtnname);
    exit ( -1 );
  }

/* Output the extracted piece of USNO-B */
 /* ASCII File Output */
  if (OFileType & CAT5_OFILE_ASC) {
    rcpttime2 (&tti, &ttu, cdate);	/* time stamp */
    fprintf (stderr, "before ascii write %s\n", cdate);
    sprintf (sv1, "%s_usnob.asc", pixr[0].pname);
    wr_starcat ( sc, &(pixr[0]), sv1 );
  }

  rcpttime2 (&tti, &ttu, cdate);	/* time stamp */
  fprintf (stderr, "after all %s\n", cdate);

  if (b_fd > 0) close (b_fd);

/* clean up and exit */
  fr_cat ( sc );

  return ( 0 );
}
