/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#include "./ubsquare.h"

/* TITLE: rdusnobc - read in a rectangular, circular or dec band */
/*                   region of USNO-B */

int rdusnobc ( PIXREGION *pixr, STARCAT *sc)
{
  char *sbrtnname={"rdusnobc"};
  int    i, j, k, p, pf, cattype, *skeep;
  double v1, v2;

/* work out the color based magnitude indices */
  UBPrimMag = 0;
  UBClr0 = 0;
  UBClr1 = 0;

  for (j = 0; j < sc->nmagcol; j++) {
    if (!strncmp(sc->magid[j], pixr->clr, 
		 MIN(strlen(sc->magid[j]),strlen(pixr->clr)))) {
      UBPrimMag = j;
    }
    if (!strncmp(sc->magid[j], pixr->clr0m1[0], 
		 MIN(strlen(sc->magid[j]),strlen(pixr->clr0m1[0])))) {
      UBClr0 = j;
    }
    if (!strncmp(sc->magid[j], pixr->clr0m1[1], 
		 MIN(strlen(sc->magid[j]),strlen(pixr->clr0m1[1])))) {
      UBClr1 = j;
    }
  }

#ifdef DEBUG
  fprintf(stderr, "%s: UBPrimMag,Clr0,Clr1 = %d %d %d\n", 
	  sbrtnname, UBPrimMag, UBClr0, UBClr1);
#endif

/* set up number of allowed objects */
  UBMaxpts    = sc->nstars;

  strcpy(sc->catname, "USNOB"); /* should use USNOBTAG */
    
/* compute bounds */
  radmnx (pixr->ra, pixr->dec, pixr->dra, pixr->ddec, 
	  &UBMnRa, &UBMxRa, &UBMnDec, &UBMxDec, 
	  &UBMnBxx, &UBMxBxx, &UBMnBxy, &UBMxBxy);

  ubnpts = 0;

  ub_oldzone = -1;
  ub_scale = 67.14;

  if      (pixr->catal & CAT3_EXT_1)  cattype = 1; /* rectangle */
  else if (pixr->catal & CAT3_EXT_2)  cattype = 2; /* circle */
  else if (pixr->catal & CAT3_EXT_3)  cattype = 3; /* dec band */
  else if (!(pixr->catal & CAT3_EXT)) cattype = 0; /* whole sky */
  else                                cattype = 1;

  ub_xyrcrnr(pixr->ra, pixr->dec, pixr->dra, pixr->ddec, cattype, 0.1);

/* check the ENV. Variables to see if the catalogue path is set there */
  b_base = getenv("USNOBDIR");
  if (b_base == (char *)NULL) {
    b_base = (char *)pixmalloc ((unsigned) sizeof(char) * (strlen(BPATH)+1),
				"rdusnob - b_base");
    strcpy (b_base, BPATH);
  }
#ifdef DEBUG
  fprintf (stderr, "%s: b_base = %s\n", sbrtnname, b_base);
#endif

  ub_nsav = 0;
  for (j=1; j <= ub_ndec; j++) {
    for (i=1; i <= ub_nra; i++) {
      k = ubc_eatit(ub_rfrst[i],ub_rlast[i],ub_dzone[j],
		   ub_dfrst[j],ub_dlast[j], pixr, sc );
      fprintf (stderr, "%s: ubnpts = %d zone = %d\n", sbrtnname,
	ubnpts, ub_dzone[j]);
      if (k < 0) return ( k );
      if (ubnpts >= UBMaxpts) break; /* break if too many stars */
    }
    if (ubnpts >= UBMaxpts) break; /* break if too many stars */
  }

  sc->nstars = ubnpts;

  fprintf (stderr, "%s: extraction done (npts = %d)\n", 
	   sbrtnname, sc->nstars);

#ifdef DEBUG
#ifndef STANDALONE
  fprintf (stderr, "PIX%06.6d - ", requestid);
#endif
  fprintf (stderr, 
	   "Found %d %d Entries\n", ub_nsav, sc->nstars);
#endif  
  return ( 0 );
}
