/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#ifdef STANDALONE
#include <stdio.h>
#include <stdlib.h>
#define ABS(x)   (((x) < 0) ? -(x) : (x))
#else
#include "../Incl/hdrs.h"
#endif

/* TITLE: d2dms - convert decimal deg to sexig string */
char *d2dms ( double dd )
{
  int  idd, idm;
  double dds;
  char sgn, *dmsstr;

  dmsstr = (char *)malloc ((unsigned)(sizeof(char)*32));

  hd2hdms ( ABS(dd), &idd, &idm, &dds );

  sgn = '+';
  if ( dd < 0 ) 
    sgn = '-';

#ifdef TESTMODE
#ifndef STANDALONE
    fprintf(stderr, "PIX%06.6d - ", requestid);
#endif
  fprintf (stderr, "d2dms: h:m:s = %02d:%02d:%lf\n", idd, idm, dds);
#endif

  if ((dds + 0.0495) >= 60.0) {
    dds = 0.0;
    idm++;
    if (idm >= 60) {
      idm = 0;
      idd++;
    }
  }

  if ( idd > 360 ) idd = idd % 360; /* put in 0 - 360 range */

  sprintf (dmsstr, "%c%02d:%02d:%04.1lf", sgn, idd, idm, dds); /* + 0.0495 */

  return ( dmsstr );
}

/* TITLE: h2hms - convert decimal hrs to sexig string */
char *h2hms ( double hd )
{
  int ihh, ihm;
  double dhs;
  char *hmsstr;

  hmsstr = (char *)malloc ((unsigned)(sizeof(char)*32));

  hd2hdms ( hd, &ihh, &ihm, &dhs );

#ifdef TESTMODE
#ifndef STANDALONE
    fprintf(stderr, "PIX%06.6d - ", requestid);
#endif
  fprintf (stderr, "h2hms: h:m:s = %02d:%02d:%lf\n", ihh, ihm, dhs);
#endif

  if ((dhs + 0.0495) >= 60.0) {
    dhs = 0.0;
    ihm++;
    if (ihm >= 60) {
      ihm = 0;
      ihh++;
    }
  }

  if ( ihh > 24 ) ihh = ihh % 24;

  sprintf (hmsstr, "%02d:%02d:%04.1lf", ihh, ihm, dhs); /* + 0.0495 */

  return ( hmsstr );
}

/* TITLE: hd2hdms - convert decimal deg/hours to h/d m s */
int hd2hdms ( double hd, int *hd1, int *hd2, double *hd3 )
{
  *hd1 = (int)hd;
  *hd2 = (int)((hd - (double)*hd1) * 60.);
  *hd3 = ((hd - (double)*hd1)*3600. - 60.* ((double)(*hd2))); /*  + 5e-8; */
  if (*hd3 >= 59.999995) {
    *hd3 = 0.0 ; /* *hd3 - 60.0; */
    *hd2 = *hd2 + 1;
  }
  if (*hd2 >= 60) {
    *hd2 = 0; /* *hd2 - 60; */
    *hd1 = *hd1 + 1;
  }

  return ( 0 );
}

