/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#include <stdio.h>
#include <time.h>
#include <sys/time.h>

/* TITLE: rcpttime - return time in secs and time in formatted string */
/*  call with ndate[19] */
int rcpttime (time_t *tti, char *ndate)
{
  int tdy, tyr; char ttm[9], tmn[4];
  *tti = time ((time_t *)0);
  sscanf(ctime(tti), "%*s %s %d %s %d", tmn, &tdy, ttm, &tyr);
  sprintf(ndate, "%02d%s%04d-%s", tdy, tmn, tyr, ttm);
  return ( 1 );
}

/* TITLE: rcpttime2 - return time in secs and time in formatted string */
/*                    include microsec portion */
/*  call with ndate[26] */
int rcpttime2 (time_t *tti, int *usec, char *ndate)
{
  int c, tdy, tyr; char ttm[9], tmn[4];
  struct timeval tp;
  struct timezone tzp;
  c = gettimeofday (&tp, &tzp);
  *tti = tp.tv_sec;
  *usec = tp.tv_usec;
  sscanf(ctime(tti), "%*s %s %d %s %d", tmn, &tdy, ttm, &tyr);
  sprintf(ndate, "%02d%3s%04d-%8s.%06d", tdy, tmn, tyr, ttm, *usec);
  return ( 1 );
}
