/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#ifdef STANDALONE
#include <stdio.h>
#include <stdlib.h>
#include "./tdefs.h"
#include "./flagbits.h"
#else
#include "../Incl/hdrs.h"
#endif

#define CCOLTST(ci,cb,vbl,typ,nam) if ((ci)&(cb)) { \
                                    sprintf(stmp, "prep_cat - %s", nam); \
                                    (vbl) = (typ *)pixmalloc \
				    ((unsigned)(sizeof(typ) * max_cat_pts), \
				    stmp); \
 				    if ((vbl) == (typ *)NULL) ci &= (~(cb)); \
                                   }
#define FCOLTST(ci,cb,vbl) if ((ci)&(cb)) { free((void *)vbl); }

/* TITLE: prep_cat - prep a STARCAT struct */
STARCAT *prep_cat (char *catalog, int max_cat_pts, int magcols, int colbits)
{
  char    stmp[64];
  int     i;
  STARCAT *sc;

  sc = (STARCAT *)pixmalloc((unsigned)(sizeof(STARCAT)), "prep_cat - sc");

  sc->nstars = max_cat_pts;
  sc->colbits = colbits;

  sprintf(sc->catname, "%s", catalog);

  CCOLTST(sc->colbits,CB_CATID0,(sc->catid[0]),int,"catid[0]");
  CCOLTST(sc->colbits,CB_CATID1,(sc->catid[1]),int,"catid[1]");

  CCOLTST(sc->colbits,CB_RADEC, (sc->ra),  double,"ra");
  CCOLTST(sc->colbits,CB_RADEC, (sc->dec), double,"dec");
  CCOLTST(sc->colbits,CB_SRADEC,(sc->sra), double,"sra");
  CCOLTST(sc->colbits,CB_SRADEC,(sc->sdec),double,"sdec");

  sc->equinox = 2000.0;

  CCOLTST(sc->colbits,CB_EPOCH,(sc->epoch),double,"epoch");

  CCOLTST(sc->colbits,CB_MU,    (sc->mura),  int,"mura");
  CCOLTST(sc->colbits,CB_MU,    (sc->mudec), int,"mudec");
  CCOLTST(sc->colbits,CB_SMU,   (sc->smura), int,"smura");
  CCOLTST(sc->colbits,CB_SMU,   (sc->smudec),int,"smudec");
  CCOLTST(sc->colbits,CB_MUPROB,(sc->muprob),int,"muprob");

  CCOLTST(sc->colbits,CB_SFIT,  (sc->srafit), int,"srafit");
  CCOLTST(sc->colbits,CB_SFIT,  (sc->sdecfit),int,"sdecfit");
  CCOLTST(sc->colbits,CB_FITPTS,(sc->fitpts), int,"fitpts");

  sc->nmagcol = magcols;

  CCOLTST(sc->colbits,CB_MAG, (sc->mag), double *,"mag");
  CCOLTST(sc->colbits,CB_SMAG,(sc->smag),double *,"smag");
  CCOLTST(sc->colbits,CB_MFLG,(sc->mflg),int *, "mflg");

  CCOLTST(sc->colbits,CB_FLDID, (sc->fldid), int *,   "fldid");
  CCOLTST(sc->colbits,CB_SG,    (sc->sg),    int *,   "sg");
  CCOLTST(sc->colbits,CB_XYRES, (sc->xres),  double *,"xres");
  CCOLTST(sc->colbits,CB_XYRES, (sc->yres),  double *,"yres");
  CCOLTST(sc->colbits,CB_PLTIDX,(sc->pltidx),int *,   "pltidx");

  for (i = 0; i < sc->nmagcol; i++) {
    sprintf(sc->magid[i], "%d", i);

    CCOLTST(sc->colbits,CB_MAG, (sc->mag[i]), double,"mag[i]");
    CCOLTST(sc->colbits,CB_SMAG,(sc->smag[i]),double,"smag[i]");
    CCOLTST(sc->colbits,CB_MFLG,(sc->mflg[i]),int,   "mflg[i]");

    CCOLTST(sc->colbits,CB_FLDID, (sc->fldid[i]), int,   "fldid[i]");
    CCOLTST(sc->colbits,CB_SG,    (sc->sg[i]),    int,   "sg[i]");
    CCOLTST(sc->colbits,CB_XYRES, (sc->xres[i]),  double,"xres[i]");
    CCOLTST(sc->colbits,CB_XYRES, (sc->yres[i]),  double,"yres[i]");
    CCOLTST(sc->colbits,CB_PLTIDX,(sc->pltidx[i]),int,   "pltidx[i]");
  }

  CCOLTST(sc->colbits,CB_ERR,(sc->err),int, "err");
  CCOLTST(sc->colbits,CB_FLG,(sc->flg),char,"flg");

  CCOLTST(sc->colbits,CB_ELB,(sc->el),double,"el"); /* ecliptic longitude */
  CCOLTST(sc->colbits,CB_ELB,(sc->eb),double,"eb"); /* ecliptic latitude */

  CCOLTST(sc->colbits,CB_GLB,(sc->gl),double,"gl"); /* galactic longitude */
  CCOLTST(sc->colbits,CB_GLB,(sc->gb),double,"gb"); /* galactic latitude */

  CCOLTST(sc->colbits,CB_XIETA,(sc->xi), double,"xi");
  CCOLTST(sc->colbits,CB_XIETA,(sc->eta),double,"eta");

  CCOLTST(sc->colbits,CB_XY,(sc->x),double,"x"); /*x coord - pix/mm/micron*/
  CCOLTST(sc->colbits,CB_XY,(sc->y),double,"y"); /*y coord - pix/mm/micron*/
  CCOLTST(sc->colbits,CB_XYM,(sc->xm),double,"xm"); /* x in ROI */
  CCOLTST(sc->colbits,CB_XYM,(sc->ym),double,"ym"); /* y in ROI */

  CCOLTST(sc->colbits,CB_ESTMAG,(sc->estmag),double,"estmag"); /* Est. Mag. */

  return ( sc );
}

/* TITLE: fr_cat - free a STARCAT struct */
int fr_cat ( STARCAT *sc )
{
  int i;

  FCOLTST(sc->colbits,CB_CATID0,sc->catid[0]);
  FCOLTST(sc->colbits,CB_CATID1,sc->catid[1]);

  FCOLTST(sc->colbits,CB_RADEC, sc->ra);
  FCOLTST(sc->colbits,CB_RADEC, sc->dec);
  FCOLTST(sc->colbits,CB_SRADEC,sc->sra);
  FCOLTST(sc->colbits,CB_SRADEC,sc->sdec);

  FCOLTST(sc->colbits,CB_EPOCH,sc->epoch);

  FCOLTST(sc->colbits,CB_MU,    sc->mura);
  FCOLTST(sc->colbits,CB_MU,    sc->mudec);
  FCOLTST(sc->colbits,CB_SMU,   sc->smura);
  FCOLTST(sc->colbits,CB_SMU,   sc->smudec);
  FCOLTST(sc->colbits,CB_MUPROB,sc->muprob);

  FCOLTST(sc->colbits,CB_SFIT,  sc->srafit);
  FCOLTST(sc->colbits,CB_SFIT,  sc->sdecfit);
  FCOLTST(sc->colbits,CB_FITPTS,sc->fitpts);

  for (i = 0; i < sc->nmagcol; i++) {
    FCOLTST(sc->colbits,CB_MAG, sc->mag[i]);
    FCOLTST(sc->colbits,CB_SMAG,sc->smag[i]);
    FCOLTST(sc->colbits,CB_MFLG,sc->mflg[i]);

    FCOLTST(sc->colbits,CB_FLDID, sc->fldid[i]);
    FCOLTST(sc->colbits,CB_SG,    sc->sg[i]);
    FCOLTST(sc->colbits,CB_XYRES, sc->xres[i]);
    FCOLTST(sc->colbits,CB_XYRES, sc->yres[i]);
    FCOLTST(sc->colbits,CB_PLTIDX,sc->pltidx[i]);
  }

  FCOLTST(sc->colbits,CB_MAG, sc->mag);
  FCOLTST(sc->colbits,CB_SMAG,sc->smag);
  FCOLTST(sc->colbits,CB_MFLG,sc->mflg);
  FCOLTST(sc->colbits,CB_FLDID, sc->fldid);
  FCOLTST(sc->colbits,CB_SG,    sc->sg);
  FCOLTST(sc->colbits,CB_XYRES, sc->xres);
  FCOLTST(sc->colbits,CB_XYRES, sc->yres);
  FCOLTST(sc->colbits,CB_PLTIDX,sc->pltidx);

  FCOLTST(sc->colbits,CB_ERR,sc->err);
  FCOLTST(sc->colbits,CB_FLG,sc->flg);

  FCOLTST(sc->colbits,CB_ELB,sc->el); /* ecliptic longitude */
  FCOLTST(sc->colbits,CB_ELB,sc->eb); /* ecliptic latitude */

  FCOLTST(sc->colbits,CB_GLB,sc->gl); /* galactic longitude */
  FCOLTST(sc->colbits,CB_GLB,sc->gb); /* galactic latitude */

  FCOLTST(sc->colbits,CB_XIETA,sc->xi);
  FCOLTST(sc->colbits,CB_XIETA,sc->eta);

  FCOLTST(sc->colbits,CB_XY,sc->x);   /*x coord - pix/mm/micron*/
  FCOLTST(sc->colbits,CB_XY,sc->y);   /*y coord - pix/mm/micron*/
  FCOLTST(sc->colbits,CB_XYM,sc->xm); /* x in ROI */
  FCOLTST(sc->colbits,CB_XYM,sc->ym); /* y in ROI */

  FCOLTST(sc->colbits,CB_ESTMAG,sc->estmag); /* Est. Mag. */
  free ((void *)sc);

  return ( 0 );
}
