/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#ifdef STANDALONE
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#else
#include "../Incl/hdrs.h"
#endif

/* TITLE: pixmalloc - allocate storage space */

void *pixmalloc ( int arspace, char *failstr )
{
  void *pixspace;

  if (arspace == 0) {
    fprintf (stderr, "pixmalloc: arspace=%d, for %s, return NULL\n",
	     arspace, failstr);
    return ( (void *)NULL );
  }

  if ( (pixspace = malloc ((size_t)(arspace))) == (void *)NULL) {
#ifndef STANDALONE
    fprintf(stderr, "PIX%06.6d - ", requestid);
#endif
    fprintf(stderr, "pixmalloc: failed to malloc %s, %d\n",
	    failstr, errno);
  } else {
    bzero ( (void *) pixspace, arspace );
  }

  return ( pixspace );
}

