/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

/*----- Flag bytes/bits -----*/
/* Catalogue int */
 /*Byte 1 */
#define CAT1_IDS       0x000000FF /* bottom byte for catalogue id # */
#define CAT1_ID_0      0x00000000 /* - None */
#define CAT1_ID_USNOA  0x00000001 /* - USNO-A2   1 */
#define CAT1_ID_ACT    0x00000002 /* - ACT       2 */
#define CAT1_ID_TYC2   0x00000004 /* - Tycho2    4 */
#define CAT1_ID_UCAC   0x00000008 /* - UCAC      8 */
#define CAT1_ID_USNOB  0x00000010 /* - USNO-B   16 */
#define CAT1_ID_6      0x00000020 /* - unused   32 */
#define CAT1_ID_7      0x00000040 /* - unused   64 */
#define CAT1_ID_8      0x00000080 /* - unused  128 */

 /*Byte 2 */
#define CAT2_MAG       0x0000FF00 /* byte 2 for magnitude(s) to estimate */
#define SHFT_CAT2_MAG  8	  /* number of bits to shift to read this */
#define MASK_CAT2_MAG  0x000000FF /* bit mask to read this */
#define CAT2_MAG_NONE  0x00000000 /* - None */
#define CAT2_MAG_U     0x00000100 /* - U     256 */
#define CAT2_MAG_B     0x00000200 /* - B     512 */
#define CAT2_MAG_V     0x00000400 /* - V    1024 */
#define CAT2_MAG_R     0x00000800 /* - R    2048 */
#define CAT2_MAG_I     0x00001000 /* - I    4096 */
#define CAT2_MAG_J     0x00002000 /* - J    8192 */
#define CAT2_MAG_K     0x00004000 /* - K   16384 */
#define CAT2_MAG_L     0x00008000 /* - L   32768 */
/* const char ClrNames[] = {"UBVRIJKL"}; */

 /*Byte 3 */
#define CAT3_EXT       0x000F0000 /* byte 3 (bottom) - type of extraction */
#define CAT3_EXT_0     0x00000000 /* None */
#define CAT3_EXT_1     0x00010000 /* extract a rectangle  65536 */
#define CAT3_EXT_2     0x00020000 /* extract a circle    131072 */
#define CAT3_EXT_3     0x00040000 /* extract a dec band  262144 */
#define CAT3_EXT_4     0x00080000 /* extract a ra wedge  524288 */

#define CAT3_OBJ       0x00F00000 /* byte 3 (top) - type of objects */
#define CAT3_OBJ_0     0x00000000 /* None */
#define CAT3_OBJ_1     0x00100000 /* stars           1048576 */
#define CAT3_OBJ_2     0x00200000 /* variable stars  2097152 */
#define CAT3_OBJ_3     0x00400000 /* galaxies        4194304 */
#define CAT3_OBJ_4     0x00800000 /* unused          8388608 */

 /*Byte 4 */
#define CAT4_BYTE      0xFF000000 /* byte 4 */
#define SHFT_CAT4_FMT  29	  /* number of bits to shift to read this */
#define MASK_CAT4_FMT  0x00000007 /* bit mask to read this */
#define CAT4_FMT       0xE0000000 /* high 3 bits for file format */
#define CAT4_FMT_0     0x00000000 /* hh mm ss format */
#define CAT4_FMT_1     0x20000000 /* hh:mm:ss format    536,870,912 */
#define CAT4_FMT_2     0x40000000 /* hh.hhh format    1,073,741,824 */
#define CAT4_FMT_3     0x60000000 /* ddd.ddd format   1,610,612,736 */
#define CAT4_FMT_4     0x80000000 /* unused           2,147,483,648 */
#define CAT4_FMT_5     0xA0000000 /* unused */
#define CAT4_FMT_6     0xC0000000 /* unused */
#define CAT4_FMT_7     0xE0000000 /* unused */

#define CAT4_SRT       0x1C000000	/* next 3 bits for sort key */
#define SHFT_CAT4_SRT  26	  /* number of bits to shift to read this */
#define MASK_CAT4_SRT  0x00000007 /* bit mask to read this */
#define CAT4_SRT_NUL   0x00000000 /* don't sort */
#define CAT4_SRT_RA    0x04000000 /* sort on RA      67,108,864 */
#define CAT4_SRT_DEC   0x08000000 /* sort on DEC    134,217,728 */
#define CAT4_SRT_MAG   0x0C000000 /* sort on MAG    201,326,592 */
#define CAT4_SRT_BMR   0x10000000 /* sort on B-R    268,435,456 */
#define CAT4_SRT_DST   0x14000000 /* sort on DIST   335,544,320 */
#define CAT4_SRT_IDX   0x18000000 /* sort on INDEX  402,653,184 */
#define CAT4_SRT_7     0x1C000000 /* unused sort */

#define CAT4_EPO       0x03000000 /* bottom 2 bits for epoch key */
#define SHFT_CAT4_EPO  24	  /* number of bits to shift to read this */
#define MASK_CAT4_EPO  0x00000003 /* bit mask to read this */
#define CAT4_EPO_0     0x00000000 /* yyyy format */
#define CAT4_EPO_1     0x01000000 /* JD format       16,777,216 */
#define CAT4_EPO_2     0x02000000 /* unused format   33,554,432 */
#define CAT4_EPO_3     0x03000000 /* unused format   50,331,648 */

#define CAT5_OFILE     0x000000FF /* First byte of a new int */
#define CAT5_OFILE_ASC 0x00000001 /*  ASCII Output */
#define CAT5_OFILE_BIN 0x00000002 /*  BINARY Output */
#define CAT5_OFILE_XML 0x00000004 /*  XML/VOTable Output */

/* Surveys int */
 /*Bytes 1-4 */
#define SVY_IDS_ALL  0xFFFFFFFF	 /* 4 bytes for survey id # */

#define SVY1_IDS     0x000000FF	 /* byte 1 for survey id # */
#define SVY1_ID_0     0x00000000  /* - None */

#define SVY1_ID_1     0x00000001  /* - POSS-I 103aO              1 */
#define SVY1_ID_2     0x00000002  /* - POSS-I 103aE              2 */

#define SVY1_ID_3     0x00000004  /* - POSS-II IIIaJ             4 */
#define SVY1_ID_4     0x00000008  /* - POSS-II IIIaF             8 */
#define SVY1_ID_5     0x00000010  /* - POSS-II IV-N             16 */

#define SVY1_ID_6     0x00000020  /* - SRC-J                    32 */
#define SVY1_ID_7     0x00000040  /* - SERC-EJ                  64 */
#define SVY1_ID_8     0x00000080  /* - ESO-R                   128 */

#define SVY2_IDS     0x0000FF00	 /* byte 2 for survey id # */
#define SVY2_ID_0     0x00000000  /* - None */

#define SVY2_ID_1     0x00000100  /* - SERC-ER                 256 */

#define SVY2_ID_2     0x00000200  /* - AAO-R                   512 */
#define SVY2_ID_3     0x00000400  /* - AAO-N                  1024 */
#define SVY2_ID_4     0x00000800  /* - AAO-sR                 2048 */

#define SVY2_ID_5     0x00001000  /* - PIMWA IV-N             4096 */
#define SVY2_ID_6     0x00002000  /* - PIMWA quick 3aF        8192 */

#define SVY2_ID_7     0x00004000  /* - LUYTEN                16384 */

#define SVY2_ID_8     0x00008000  /* - SPM (Blue)            32768 */

#define SVY3_IDS     0x00FF0000	 /* byte 3 for survey id # */
#define SVY3_ID_0     0x00000000  /* - None */

#define SVY3_ID_1     0x00010000  /* - SPM (Yellow)          65536 */

#define SVY3_ID_2     0x00020000  /* - UCAC                 131072 */

#define SVY3_ID_3     0x00040000  /* - POSS-I Rej. 103aO    262144 */
#define SVY3_ID_4     0x00080000  /* - POSS-I Rej. 103aE    524288 */

#define SVY3_ID_5     0x00100000  /* - POSS-II Rej. IIIaJ  1048576 */
#define SVY3_ID_6     0x00200000  /* - POSS-II Rej. IIIaF  2097152 */
#define SVY3_ID_7     0x00400000  /* - POSS-II Rej. IIIaN  4194304 */

#define SVY3_ID_8     0x00800000  /* -  8388608 */

#define SVY4_IDS     0xFF000000	 /* byte 4 for survey id # */
#define SVY4_ID_0     0x00000000  /* - None */
#define SVY4_ID_1     0x01000000  /* -  */
#define SVY4_ID_2     0x02000000  /* -  */
#define SVY4_ID_3     0x04000000  /* -  */
#define SVY4_ID_4     0x08000000  /* -  */
#define SVY4_ID_5     0x10000000  /* -  */
#define SVY4_ID_6     0x20000000  /* -  */
#define SVY4_ID_7     0x40000000  /* -  */
#define SVY4_ID_8     0x80000000  /* -  */

/* Survey defines by name */
#define SVY_POSSI_O   SVY1_ID_1
#define SVY_POSSI_E   SVY1_ID_2

#define SVY_POSSII_J  SVY1_ID_3
#define SVY_POSSII_F  SVY1_ID_4
#define SVY_POSSII_N  SVY1_ID_5

#define SVY_SRC_J     SVY1_ID_6
#define SVY_SERC_EJ   SVY1_ID_7
#define SVY_ESO_R     SVY1_ID_8
#define SVY_SERC_ER   SVY2_ID_1

#define SVY_AAO_R     SVY2_ID_2
#define SVY_AAO_N     SVY2_ID_3
#define SVY_AAO_SR    SVY2_ID_4

#define SVY_PIMWA_N   SVY2_ID_5
#define SVY_PIMWA_F   SVY2_ID_6

#define SVY_LUYTEN    SVY2_ID_7

#define SVY_SPM_B     SVY2_ID_8
#define SVY_SPM_Y     SVY3_ID_1

#define SVY_UCAC      SVY3_ID_2

#define SVY_POSSIR_O  SVY3_ID_3
#define SVY_POSSIR_E  SVY3_ID_4

#define SVY_POSSIIR_J  SVY3_ID_5
#define SVY_POSSIIR_F  SVY3_ID_6
#define SVY_POSSIIR_N  SVY3_ID_7

#define SVY_IDS_POSSI  (SVY_POSSI_O   | SVY_POSSI_E)
#define SVY_IDS_POSSII (SVY_POSSII_J  | SVY_POSSII_F | SVY_POSSII_N)
#define SVY_IDS_POSS   (SVY_IDS_POSSI | SVY_IDS_POSSII)

#define SVY_IDS_SRCJ   (SVY_SRC_J)
#define SVY_IDS_ESOR   (SVY_ESO_R)
#define SVY_IDS_SERCE  (SVY_SERC_EJ  | SVY_SERC_ER)
#define SVY_IDS_SOUTH  (SVY_IDS_SRCJ | SVY_IDS_ESOR | SVY_IDS_SERCE)

#define SVY_IDS_AAOR   (SVY_AAO_R)
#define SVY_IDS_AAON   (SVY_AAO_N)
#define SVY_IDS_AAOSR  (SVY_AAO_SR)
#define SVY_IDS_AAO    (SVY_IDS_AAOR | SVY_IDS_AAON | SVY_IDS_AAOSR)

#define SVY_IDS_PIMWA   (SVY_PIMWA_N | SVY_PIMWA_F)

#define SVY_IDS_GALPL   (SVY_IDS_PIMWA | SVY_IDS_AAOSR)

#define SVY_IDS_POSSIR  (SVY_POSSIR_O   | SVY_POSSIR_E)
#define SVY_IDS_POSSIIR (SVY_POSSIIR_J  | SVY_POSSIIR_F | SVY_POSSIIR_N)
#define SVY_IDS_POSSR   (SVY_IDS_POSSIR | SVY_IDS_POSSIIR)

/* Ticks int */
 /* Byte 1 - tick styles */
#define TK1_STY     0x000000FF   /* byte 1, style of ticks */
#define TK1_STY_0   0x00000000    /* - none */
#define TK1_STY_NE  0x00000001    /* - N/E lbl                1 */
#define TK1_STY_TK  0x00000002    /* - ticks                  2 */
#define TK1_STY_GR  0x00000004    /* - grid                   4 */
#define TK1_STY_4   0x00000008    /* - unused                 8 */
#define TK1_STY_5   0x00000010    /* - unused                16 */
#define TK1_STY_6   0x00000020    /* - unused                32 */
#define TK1_STY_7   0x00000040    /* - unused                64 */
#define TK1_STY_FC  0x00000080    /* - Finder Chart         128 */

 /* Byte 2 - overplotting */
#define TK2_OVP     0x0000FF00   /* byte 2, overplot stuff */
#define TK2_OVP_0   0x00000000    /* - none */
#define TK2_OVP_IMG 0x00000100    /* - image                256 */
#define TK2_OVP_CM  0x00000200    /* - center mark          512 */
#define TK2_OVP_CAT 0x00000400    /* - catalogues         1,024 */
#define TK2_OVP_NOZ 0x00000800    /* -  mag!=0 objects    2,048 */
#define TK2_OVP_OBJ 0x00001000    /* - overplot objs      4,096 */
#define TK2_OBJ_PT  0x00002000    /* -  overplot point    8,192 */
#define TK2_OBJ_LBL 0x00004000    /* -  overplot labels  16,384 */
#define TK2_OBJ_CON 0x00008000    /* -  overplot connect 32,768 */

 /* Byte 3 -  */
#define TK3          0x00FF0000   /* byte 3, miscellaneous stuff */
#define TK3_0        0x00000000    /* - none */
#define TK3_RTV      0x00010000	   /* retrieve from tape to disk only 65,536 */
#define TK3_OVP_RD   0x00020000    /* plot position 131,072 */
#define TK3_OVP_MU   0x00040000    /* plot prev. 50yrs of motion 262,144*/
#define TK3_OVP_LB   0x00080000    /* plot catalogue id */

/* Column Bits for Star Catalogues */
  /* bit shifts for each column */

  /* byte 1 */
#define SB_CATID0 (0)
#define SB_CATID1 (SB_CATID0 + 1)
#define SB_RADEC  (SB_CATID1 + 1)
#define SB_SRADEC (SB_RADEC  + 1)
#define SB_EPOCH  (SB_SRADEC + 1)
#define SB_MU     (SB_EPOCH  + 1)
#define SB_MUPROB (SB_MU     + 1)
#define SB_SMU    (SB_MUPROB + 1)

  /* byte 2 */
#define SB_SFIT   (SB_SMU    + 1)
#define SB_FITPTS (SB_SFIT   + 1)
#define SB_ERR    (SB_FITPTS + 1)
#define SB_FLG    (SB_ERR    + 1)
#define SB_MAG    (SB_FLG    + 1)
#define SB_SMAG   (SB_MAG    + 1)
#define SB_MFLG   (SB_SMAG   + 1)
#define SB_FLDID  (SB_MFLG   + 1)

  /* byte 3 */
#define SB_SVY    (SB_FLDID  + 1)
#define SB_SG     (SB_SVY    + 1)
#define SB_XYRES  (SB_SG     + 1)
#define SB_PLTIDX (SB_XYRES  + 1)
#define SB_XIETA  (SB_PLTIDX + 1)
#define SB_ELB    (SB_XIETA  + 1)
#define SB_GLB    (SB_ELB    + 1)
#define SB_MUGLB  (SB_GLB    + 1)

  /* byte 4 */
#define SB_XY     (SB_MUGLB  + 1)
#define SB_XYM    (SB_XY     + 1)
#define SB_RADIUS (SB_XYM    + 1)
#define SB_ESTMAG (SB_RADIUS + 1)
#define SB_OPEN1  (SB_ESTMAG + 1)
#define SB_OPEN2  (SB_OPEN1  + 1)
#define SB_OPEN3  (SB_OPEN2  + 1)
#define SB_XORY   (SB_OPEN3  + 1)

  /* extra values to handle pairs */
#define SB_RA      (SB_RADEC)
#define SB_DEC     (SB_RADEC  + SB_XORY)
#define SB_SRA     (SB_SRADEC)
#define SB_SDEC    (SB_SRADEC + SB_XORY)
#define SB_SPOS    (SB_SRADEC + 2 * SB_XORY)

#define SB_MURA    (SB_MU)
#define SB_MUDEC   (SB_MU    + SB_XORY)
#define SB_MUTOT   (SB_MU    + 2 * SB_XORY)

#define SB_SMURA   (SB_SMU)
#define SB_SMUDEC  (SB_SMU   + SB_XORY)
#define SB_SMUTOT  (SB_SMU   + 2 * SB_XORY)

#define SB_SFITRA  (SB_SFIT)
#define SB_SFITDEC (SB_SFIT  + SB_XORY)
#define SB_SFITTOT (SB_SFIT  + 2 * SB_XORY)

#define SB_CLR     (SB_MAG   + SB_XORY)

#define SB_XRES    (SB_XYRES)
#define SB_YRES    (SB_XYRES + SB_XORY)

#define SB_XI      (SB_XIETA)
#define SB_ETA     (SB_XIETA + SB_XORY)

#define SB_EL      (SB_ELB)
#define SB_EB      (SB_ELB   + SB_XORY)

#define SB_GL      (SB_GLB)
#define SB_GB      (SB_GLB   + SB_XORY)

#define SB_MUGL    (SB_MUGLB)
#define SB_MUGB    (SB_MUGLB + SB_XORY)

#define SB_X       (SB_XY)
#define SB_Y       (SB_XY    + SB_XORY)

#define SB_XM      (SB_XYM)
#define SB_YM      (SB_XYM   + SB_XORY)

 /* The column bits */
  /* byte 1 */
#define CB_CATID0 (1<<SB_CATID0) /*   1 */
#define CB_CATID1 (1<<SB_CATID1) /*   2 */

#define CB_RADEC  (1<<SB_RADEC)	 /*   4 */
#define CB_SRADEC (1<<SB_SRADEC) /*   8 */

#define CB_EPOCH  (1<<SB_EPOCH)  /*  16 */
			    
#define CB_MU     (1<<SB_MU)	 /*  32 */
#define CB_MUPROB (1<<SB_MUPROB) /*  64 */
#define CB_SMU    (1<<SB_SMU)	 /* 128 */
				 /*  BYTE SUM = 255 */
  /* byte 2 */
#define CB_SFIT   (1<<SB_SFIT)	 /*   256 */
#define CB_FITPTS (1<<SB_FITPTS) /*   512 */
		  
#define CB_ERR    (1<<SB_ERR)	 /*  1024 */
#define CB_FLG    (1<<SB_FLG)	 /*  2048 */
		  
#define CB_MAG    (1<<SB_MAG)	 /*  4096 */
#define CB_SMAG   (1<<SB_SMAG)	 /*  8192 */
#define CB_MFLG   (1<<SB_MFLG)	 /* 16384 */
#define CB_FLDID  (1<<SB_FLDID)	 /* 32768 */
				 /*  BYTE SUM    = 65280 */
				 /*  RUNNING SUM = 65535 */

  /* byte 3 */
#define CB_SVY    (1<<SB_SVY)	/* 65536 */
		  
#define CB_SG     (1<<SB_SG)	/*   131072 */
#define CB_XYRES  (1<<SB_XYRES)	/*   262144 */
				/*  PARTIAL SUM = 458752 */
				/*  RUNNING SUM = 524287 */
#define CB_PLTIDX (1<<SB_PLTIDX)	/*   524288 */
				/*  PARTIAL SUM = 983040 */
				/*  RUNNING SUM = 1048575 */
		  
#define CB_XIETA  (1<<SB_XIETA)	/*  1048576 */
#define CB_ELB    (1<<SB_ELB)	/*  2097152 */
#define CB_GLB    (1<<SB_GLB)	/*  4194304 */
#define CB_MUGLB  (1<<SB_MUGLB)	/*  8388608 */
				/*  BYTE SUM    =  */
				/*  RUNNING SUM =  */

  /* byte 4 */
#define CB_XY     (1<<SB_XY)	/*  16777216 */
#define CB_XYM    (1<<SB_XYM)	/*  33554432 */
		  
#define CB_RADIUS (1<<SB_RADIUS) /*  67108864 */
#define CB_ESTMAG (1<<SB_ESTMAG) /* 134217728 */
		  
#define CB_OPEN1  (1<<SB_OPEN1)	/*  268435456 */
#define CB_OPEN2  (1<<SB_OPEN2)	/*  536870912 */
#define CB_OPEN3  (1<<SB_OPEN3)	/* 1073741824 */
#define CB_XORY   (1<<SB_XORY)	/* 2147483648 */

/* define various subsets of the Column Bits */
#define CGRP_ID    ( CB_CATID0 | CB_CATID1 )                    /* 3 */
#define CGRP_BASIC ( CB_RADEC | CB_MU | CB_MAG | CB_SG )        /* 135204 */
#define CGRP_SIG   ( CB_SRADEC | CB_SMU | CB_SFIT | CB_SMAG )   /* 8584 */
#define CGRP_AUX   ( CB_FITPTS | CB_EPOCH | CB_MUPROB )	        /* 592 */
#define CGRP_FLGS  ( CB_ERR | CB_FLG | CB_MFLG )                /* 19456 */
#define CGRP_LKBCK ( CB_FLDID | CB_SVY | CB_XYRES | CB_PLTIDX )	/* 884736 */
#define CGRP_TANP  ( CB_XIETA | CB_RADIUS )                     /* 34603008 */
#define CGRP_EXXY  ( CB_XY | CB_XYM )                           /* 25165824 */
#define CGRP_COORD ( CB_ELB | CB_GLB )                          /* 6291456 */
#define CGRP_EXMAG ( CB_ESTMAG )                                /* 67108864 */

#define CSET_SML ( CGRP_ID | CGRP_BASIC | CGRP_TANP )           /* 34738215 */
#define CSET_MED ( CSET_BASIC | CGRP_SIG | CGRP_AUX )           /* 34747391 */
#define CSET_LRG ( CSET_MED | CGRP_FLGS | CGRP_LKBCK )          /* 35651583 */

/* Bits packed into the Gzip int (not just gzip anymore) */
#define GZF_GZIP      0x00000001 /* compress with gzip */
#define GZF_BZIP      0x00000002 /* compress with bzip2 */

/* byte 2 - output file type */
#define GZF_FTYPE_BYTE 0x0000FF00 /* 2nd byte for file type selection */
#define GZF_FTYPE_STD  0x00000100 /* File type - Off=HTML/On=STDOUT */
#define GZF_FTYPE_ASC  0x00000200 /* File type - ASCII */
#define GZF_FTYPE_BIN  0x00000400 /* File type - BINARY */
#define GZF_FTYPE_XML  0x00000800 /* File type - XML/VOTable */
#define GZF_FTYPE_DMP  0x00008000 /* Set for ASCII dump */

/* byte 3 - catalogue sort column selection */
#define GZF_SORT_BYTE 0x00FF0000 /* 3rd byte for sort key bits */
#define GZF_SORT_SHFT (16)
#define GZF_GSORT_VAL(x) ( (((x)&(GZF_SORT_BYTE))>>GZF_SORT_SHFT)&0x000000FF )
#define GZF_SSORT_VAL(x) ( (((x)&0x000000FF)<<GZF_SORT_SHFT)&(GZF_SORT_BYTE) )

/* byte 4 - open */

