/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#ifdef STANDALONE
#include <stdio.h>
#include "./tdefs.h"
#include "./flagbits.h"
#else
#include "../Incl/hdrs.h"
#endif

/* TITLE: columnbits - set star catalogue column bits */
int columnbits (STARCAT *sc)
{

/* set up a bit mask to indicate which columns have data */
  sc->colbits = 0;

  if (sc->catid[0] != (int    *)NULL)  sc->colbits |= CB_CATID0;
  if (sc->catid[1] != (int    *)NULL)  sc->colbits |= CB_CATID1;

  if ((sc->ra      != (double *)NULL) &&
      (sc->dec     != (double *)NULL)) sc->colbits |= CB_RADEC;

  if ((sc->sra     != (double *)NULL) &&
      (sc->sdec    != (double *)NULL)) sc->colbits |= CB_SRADEC;

  if (sc->epoch    != (double *)NULL)  sc->colbits |= CB_EPOCH;

  if ((sc->mura    != (int    *)NULL) && 
      (sc->mudec   != (int    *)NULL)) sc->colbits |= CB_MU;

  if (sc->muprob   != (int    *)NULL)  sc->colbits |= CB_MUPROB;
						 
  if ((sc->smura   != (int    *)NULL) &&	 
      (sc->smudec  != (int    *)NULL)) sc->colbits |= CB_SMU;
						 
  if ((sc->srafit  != (int    *)NULL) &&	 
      (sc->sdecfit != (int    *)NULL)) sc->colbits |= CB_SFIT;
						 
  if (sc->fitpts   != (int    *)NULL)  sc->colbits |= CB_FITPTS;
						 
  if (sc->err      != (int    *)NULL)  sc->colbits |= CB_ERR;
						 
  if (sc->flg      != (char   *)NULL)  sc->colbits |= CB_FLG;
						 
  if (sc->nmagcol > 0) {			 
    if (sc->mag   != (double **)NULL)  sc->colbits |= CB_MAG;
    if (sc->smag  != (double **)NULL)  sc->colbits |= CB_SMAG;
    if (sc->mflg  != (int    **)NULL)  sc->colbits |= CB_MFLG;
    if (sc->fldid != (int    **)NULL)  sc->colbits |= CB_FLDID;
    if (sc->sg    != (int    **)NULL)  sc->colbits |= CB_SG;
    if ((sc->xres != (double **)NULL) &&	 
        (sc->yres != (double **)NULL)) sc->colbits |= CB_XYRES;
    if (sc->pltidx!= (int    **)NULL)  sc->colbits |= CB_PLTIDX;
  }						 
						 
  if ((sc->xi      != (double *)NULL) &&	 
      (sc->eta     != (double *)NULL)) sc->colbits |= CB_XIETA;
						 
  if ((sc->el      != (double *)NULL) &&	 
      (sc->eb      != (double *)NULL)) sc->colbits |= CB_ELB;
						 
  if ((sc->gl      != (double *)NULL) &&	 
      (sc->gb      != (double *)NULL)) sc->colbits |= CB_GLB;
						 
  if ((sc->x       != (double *)NULL) &&	 
      (sc->y       != (double *)NULL)) sc->colbits |= CB_XY;
						 
  if ((sc->xm      != (double *)NULL) &&	 
      (sc->ym      != (double *)NULL)) sc->colbits |= CB_XYM;

  return ( 0 );
}
