/* Copyright USNO, all rights reserved */

#include	<stdio.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<netinet/in.h>

/* TITLE:   c_opener_  --  Open A NEW File */
int c_opener_(char bb[])
{
  return(creat(bb,0644));
}

/* TITLE:   c_closer_  --  Close A File */
int c_closer_(int *fd)
{
  return(close(*fd));
}

/* TITLE:  c_writer_  --  Use HTONL() To Select ENDIAN */
int c_writer_(int *fd, char buf[], int *n)
{
  u_long x;
  int i, nn;
  char b;

  nn = (*n);
  x = 102030405;
  if (htonl(x) != x) {
    for (i=0; i<nn; i+=4) {
      b = buf[i  ];
      buf[i  ] = buf[i+3];
      buf[i+3] = b;
      b = buf[i+1];
      buf[i+1] = buf[i+2];
      buf[i+2] = b;
    }
  }
  i = write(*fd,buf,nn);
  if (nn == i)
    return(0);
  else
    return(i);
}

/* TITLE: c_reader_  --  Use HTONL() To Select ENDIAN */
int c_reader_(int *fd, char buf[], int *n)
{
  u_long x;
  int i, nn;
  char b;

  nn = (*n);
  i = read(*fd,buf,nn);
  if (i == nn) {
    x = 102030405;
    if (htonl(x) != x) {
      for (i=0; i<nn; i+=4) {
	b = buf[i  ];
	buf[i  ] = buf[i+3];
	buf[i+3] = b;
	b = buf[i+1];
	buf[i+1] = buf[i+2];
	buf[i+2] = b;
      }
    }
    return(0);
  } else
    return(i);
}

/* TITLE:  c_roopen_ -- Open A ReadOnly File */
int c_roopen_(char bb[])
{
  return(open(bb,0));
}

/* TITLE: c_genlen_  --  Return The Length Of A File */
int c_genlen_(char bb[])
{
  int fd, n;

  if ((fd=open(bb,0)) < 3)
    return(-1);
  n = (int)lseek(fd, 0, SEEK_END);
  close(fd);
  return(n);
}

/* TITLE:  c_position_  --  Move file pointer */
int c_position_(int *fd, int *nb)
{
  return(lseek(*fd, *nb, SEEK_SET));
}

/* TITLE:  c_rawwriter_  --  Just scribble */
int c_rawwriter_(int *fd, char bb[], int *n)
{
  int i, nn;

  nn = (*n);
  i = write(*fd,bb,nn);
  if (i == nn)
    return(0);
  else
    return(i);
}

/* TITLE:  c_rawreader_ -- Just read */
int c_rawreader_(int *fd, char bb[], int *n)
{
  int i, nn;

  nn = (*n);
  i = read(*fd,bb,nn);
  if (i == nn)
    return(0);
  else
    return(i);
}
