/* Written by Stephen Levine @ the US Naval Observatory, Flagstaff */
/* Copyright USNO, all rights reserved */

#ifdef STANDALONE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "./tdefs.h"
#include "./flagbits.h"
#define ABS(x)   (((x) < 0) ? -(x) : (x))
#define MAX(a,b) (((a) < (b)) ? (b) : (a))
#define MIN(a,b) (((a) > (b)) ? (b) : (a))
#else
#include "../Incl/hdrs.h"
#endif

#define PICKSORT(sb,cb) ((col2sort == (sb)) && (mergbits & (cb)))
#define DSRT(cl) dindexx((unsigned long)sc->nstars, (sc->cl)-1, skey-1 )
#define ISRT(cl) iindexx((unsigned long)sc->nstars, (sc->cl)-1, skey-1 )

#define SQRSRT(cla,clb) \
      for (i = 0; i < sc->nstars; i++) \
        dvarr[i] = (double)((sc->cla[i]*sc->cla[i])+(sc->clb[i]*sc->clb[i])); \
      dindexx ( (unsigned long)sc->nstars, dvarr-1, skey-1 ); \
      free ((void *) dvarr );

#define BYCLR(rtn,clmn)  for (i = 0; i < sc->nmagcol; i++) { \
  if (!strncmp(pixr->clr,sc->magid[i],\
	       MIN(strlen(pixr->clr),strlen(sc->magid[i])))) {\
    rtn ( (unsigned long)sc->nstars, (sc->clmn[i])-1, skey-1 );\
    break;\
  } }

/* TITLE: cat_sort - sort catalogue based on select column */
int cat_sort (STARCAT *sc, PIXREGION *pixr, int mergbits, 
	      double *dtoctr, unsigned long *skey)
{
  char *sbrtnname = {"cat_sort"};

  int col2sort;
  int i, ic0 = 0, ic1 = 1;
  double *dvarr;

  col2sort = GZF_GSORT_VAL ( pixr->gzflg ); /* get the sort column index */

#ifdef DEBUG
  fprintf (stderr, "%s - col2sort = %d(0x%x) gzf = %d(0x%x)\n", sbrtnname, 
	   col2sort, col2sort, pixr->gzflg, pixr->gzflg);
#endif

  if (col2sort == 0) return ( 0 ); /* no sort requested */

/* malloc space for temporary array for computed variable sorting */
  if (col2sort == SB_SPOS   ||
      col2sort == SB_MUTOT  ||
      col2sort == SB_SMUTOT ||
      col2sort == SB_SFITTOT ||
      col2sort == SB_CLR) {

    dvarr = (double *)pixmalloc((unsigned)(sizeof(double) * sc->nstars),
				"cat_sort - dvarr");

    if ( dvarr == (double *)NULL ) {
      fprintf (stderr, "%s - Unable to malloc space, not sorting\n",
	       sbrtnname);
      return ( 0 );
    }
  }

  if      (PICKSORT(SB_CATID0, CB_CATID0)) { ISRT(catid[0]); }

  else if (PICKSORT(SB_RA,     CB_RADEC))  { DSRT(ra); }
  else if (PICKSORT(SB_DEC,    CB_RADEC))  { DSRT(dec); }

  else if (PICKSORT(SB_SRA,    CB_SRADEC)) { DSRT(sra); }
  else if (PICKSORT(SB_SDEC,   CB_SRADEC)) { DSRT(sdec); }
  else if (PICKSORT(SB_SPOS,   CB_SRADEC)) { SQRSRT(sra,sdec); }

  else if (PICKSORT(SB_EPOCH,  CB_EPOCH))  { DSRT(epoch); }

  else if (PICKSORT(SB_MURA,   CB_MU))     { ISRT(mura); }
  else if (PICKSORT(SB_MUDEC,  CB_MU))     { ISRT(mudec); }
  else if (PICKSORT(SB_MUTOT,  CB_MU))     { SQRSRT(mura,mudec); }

  else if (PICKSORT(SB_MUPROB, CB_MUPROB)) { ISRT(muprob); }

  else if (PICKSORT(SB_SMURA,  CB_SMU))    { ISRT(smura); }
  else if (PICKSORT(SB_SMUDEC, CB_SMU))    { ISRT(smudec); }
  else if (PICKSORT(SB_SMUTOT, CB_SMU))    { SQRSRT(smura,smudec); }

  else if (PICKSORT(SB_SFITRA, CB_SFIT))   { ISRT(srafit); }
  else if (PICKSORT(SB_SFITDEC,CB_SFIT))   { ISRT(sdecfit); }
  else if (PICKSORT(SB_SFITTOT,CB_SFIT))   { SQRSRT(srafit,sdecfit); }

  else if (PICKSORT(SB_FITPTS, CB_FITPTS)) { ISRT(fitpts); }
  else if (PICKSORT(SB_ERR,    CB_ERR))    { ISRT(err); }

  else if (PICKSORT(SB_MAG,    CB_MAG))    { BYCLR(dindexx,mag); }

/* compute color and sort on it */
  else if (PICKSORT(SB_CLR,    CB_MAG))    { 

    /* get the indices of the respective magnitudes */
    for (i = 0; i < sc->nmagcol; i++) {
      if (!strncmp(pixr->clr0m1[0],sc->magid[i],
	       MIN(strlen(pixr->clr0m1[0]),strlen(sc->magid[i]))))
	ic0 = i;
      if (!strncmp(pixr->clr0m1[1],sc->magid[i],
	       MIN(strlen(pixr->clr0m1[1]),strlen(sc->magid[i]))))
	ic1 = i;
    }

    if (ic0 >= sc->nmagcol || ic1 >= sc->nmagcol ||
	ic0 < 0            || ic1 < 0) {
      /* error condition , ie one or both indices are out of range */
      fprintf (stderr, "%s - Color Index out of range (%d, %d), not sorting\n",
		 sbrtnname, ic0, ic1);
    } else {	
      for (i = 0; i < sc->nstars; i++){
	dvarr[i] = sc->mag[ic0][i] - sc->mag[ic1][i];
      }

      dindexx ( (unsigned long)sc->nstars, dvarr-1, skey-1 );
      free ((void *) dvarr );
    }
  }

  else if (PICKSORT(SB_SMAG,   CB_SMAG))   { BYCLR(dindexx,smag); }
  else if (PICKSORT(SB_MFLG,   CB_MFLG))   { BYCLR(iindexx,mflg); }
  else if (PICKSORT(SB_FLDID,  CB_FLDID))  { BYCLR(iindexx,fldid); }
  else if (PICKSORT(SB_SVY,    CB_SVY))    { BYCLR(iindexx,fldid); }
  else if (PICKSORT(SB_SG,     CB_SG))     { BYCLR(iindexx,sg); }
  else if (PICKSORT(SB_XRES,   CB_XYRES))  { BYCLR(dindexx,xres); }
  else if (PICKSORT(SB_YRES,   CB_XYRES))  { BYCLR(dindexx,yres); }
  else if (PICKSORT(SB_PLTIDX, CB_PLTIDX)) { BYCLR(iindexx,pltidx); }

  else if (PICKSORT(SB_XI ,    CB_XIETA))  { DSRT(xi); }
  else if (PICKSORT(SB_ETA,    CB_XIETA))  { DSRT(eta); }
						  
  else if (PICKSORT(SB_EL,     CB_ELB))    { DSRT(el); }
  else if (PICKSORT(SB_EB,     CB_ELB))    { DSRT(eb); }
						  
  else if (PICKSORT(SB_GL ,    CB_GLB))    { DSRT(gl); }
  else if (PICKSORT(SB_GB ,    CB_GLB))    { DSRT(gb); }
						  
/* 					   	  
  else if (PICKSORT(SB_MUGL ,  CB_MUGLB))  { DSRT(mugl); }
  else if (PICKSORT(SB_MUGB ,  CB_MUGLB))  { DSRT(mugb); }
*/					   	  
						  
  else if (PICKSORT(SB_X,      CB_XY))     { DSRT(x); }
  else if (PICKSORT(SB_Y,      CB_XY))     { DSRT(y); }
  else if (PICKSORT(SB_XM,     CB_XYM))    { DSRT(xm); }
  else if (PICKSORT(SB_YM,     CB_XYM))    { DSRT(ym); }

  else if (PICKSORT(SB_RADIUS, CB_RADIUS) && (dtoctr != (double *)NULL))
    dindexx ( (unsigned long)sc->nstars, dtoctr-1, skey-1 );

  else if (PICKSORT(SB_ESTMAG, CB_ESTMAG)) { DSRT(estmag); }

  return ( 1 );
}
